<?php
/**
* Modal Map
* @author fred - Advantis Solutions
* @version 1.0.1
* @package Backend\SIG
*/
?>

<link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-0.7.2/leaflet.css">

<!-- Modal -->
<div class="modal fade" id="mapModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-body" >
            <style>
                #map { height: 100%; }
            </style>
            <div id="map" class="modal-body"></div>
      </div>
    </div>
  </div>
</div>


<script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-0.7.2/leaflet.js"></script>
<script>
    
    var mapquestOSM = L.tileLayer("https://{s}.mqcdn.com/tiles/1.0.0/osm/{z}/{x}/{y}.png", {
        maxZoom: 19,
        subdomains: ["otile1", "otile2", "otile3", "otile4"],
        attribution: 'Tiles courtesy of <a href="http://www.mapquest.com/" target="_blank">MapQuest</a> <img src="http://developer.mapquest.com/content/osm/mq_logo.png">. Map data (c) <a href="http://www.openstreetmap.org/" target="_blank">OpenStreetMap</a> contributors, CC-BY-SA.'
    });
	var OpenStreetMap_Mapnik = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
		maxZoom: 19,
		attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
	});
    
    var map = L.map("map", {
        zoom: 2,
        minZoom: 2,
        center: [15, 15],
        maxBounds: ([[-90, -180], [90, 180]]),
        layers: [OpenStreetMap_Mapnik]
    });
    

    var marker;
    var markers = [];
    
    function pinMarker(lat,lng) { 
        marker = new L.marker([lat,lng], {id:1,dragable:'false'});
        map.addLayer(marker);
    };
    

    function mapZoomTo(lat,lng,zoom) { //default: zoom=8 
        var latlng = L.latLng(lat, lng);
        map.setView(latlng,zoom || 8,true);
    };
    
    
    
   function showMapModalArray(latLngArray,zoomToPointsExtent) {
        for (i=0;i<markers.length;i++) {
            map.removeLayer(markers[i]);
        }
        
        if (!isArray(latLngArray)) {return;}
        
        var latLngs = [];
        for (i=0;i<latLngArray.length;i++) {
            var coords = latLngArray[i].split(',');
            if (coords.length < 2) {return;}
            latLngs[i] = L.latLng(coords[0],coords[1]);
            markers[i] = new L.marker([coords[0],coords[1]], {title:coords[1] || null ,id:i,draggable:'false'});
            map.addLayer(markers[i]);  
        }
  
        $('#mapModal').modal('toggle');
        setTimeout(function(){ 
            map.invalidateSize();
            if (zoomToPointsExtent) { map.fitBounds(L.latLngBounds(latLngs).pad(0.1));}
        }, 400);

    }
    
    
    function isArray(myArray) {
        return myArray.constructor.toString().indexOf("Array") > -1;
    }
    
</script>


<?php
if (isset($_GET['geo'])) {
$param = explode(";",$_GET['geo']);
    echo ("
        <script>
            pinMarker($param[0],$param[1]);
        </script>
    ");
}
?>
