<?php
// For dev mode 
error_reporting(E_ERROR | E_WARNING | E_PARSE);
ini_set('display_errors', true);
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="initial-scale=1,user-scalable=no,maximum-scale=1,width=device-width">
        <meta name="mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="description" content="">
        <meta name="Advantis (Fred)" content="user" >
        <title><?= R('title_MoSy WebGIS') ?></title>

        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/css/bootstrap.min.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/font-awesome/css/font-awesome.min.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-0.7.2/leaflet.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-sidebar/L.Control.Sidebar.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-easyPrint/easyPrint.css"/>

        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.markercluster/MarkerCluster.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.markercluster/MarkerCluster.Default.css" />

        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/css/main.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/css/metadata.css" />

        <link rel="apple-touch-icon" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/img/favicon-152.png" />
        <link rel="shortcut icon" sizes="196x196" href="<?= __SITEBASE ?>/<?= __THEME ?>/resources/websig/img/favicon-196.png" />

        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.measure/leaflet.measure.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/extendedLayerControl/css/extendedLayerControl.css" />
        <link rel="stylesheet" href="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/spectrum/spectrum.css" />

    </head>


    <body>
        <div class="navbar navbar-inverse navbar-fixed-top" role="navigation">

            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="<?= __SITEBASE ?>">MoSy</a>
            </div>

            <div class="navbar-collapse collapse">
                <form class="navbar-form navbar-right" role="search">
                    <div class="form-group has-feedback navbar-right">
                        <input id="searchbox" type="text" placeholder="Search" class="form-control">
                        <span id="searchicon" class="fa fa-search form-control-feedback"></span>
                    </div>
                </form>
                <ul class="nav navbar-nav">
                    <li class="dropdown">
                        <a id="toolsDrop" href="#" role="button" class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-list" style="color: white"></i>&nbsp;&nbsp;<?= R('l_Layers') ?><b class="caret"></b></a>
                        <ul class="dropdown-menu">
                            <li><a href="#" data-toggle="collapse" data-target=".navbar-collapse.in" onclick="$('#addLayer').modal('show');
                                    return false;">
                                    <i class="fa fa-plus"></i>&nbsp;&nbsp;<?= R('l_add_layers') ?></a></li>
                        </ul>
                    </li>
                    <li><a id="statisticPanel" href="#" data-toggle="collapse" data-target=".navbar-collapse.in" ><i class="fa fa-tasks" style="color: white"></i>&nbsp;&nbsp;<?= R('l_Explore_Data') ?></a></li>
                </ul>
            </div>
        </div>

        <div id="map"></div>

        <div id="sidebar">
            <h2><?= R('MoSy Project') ?></h2>

            <div class="lorem">
                <h3><?= R('Objectives') ?></h3>
                <?= R('Objectives') ?>
                <p>The project involves three levels: European, national and local level:</p>
                <ol class="arabic simple">
                    <li>at <strong>European level</strong>, the objective is to support
                        the <strong>sharing</strong> of consistent and harmonised statistics on Trafficking in Human Beings (THB)
                        between Member States (MS) of the European Union (EU);</li>
                    <li>at the <strong>national level</strong>, the objective is to support
                        the <strong>integration</strong> of consistent data
                        and the <strong>production</strong> of harmonized statistics on THB;</li>
                    <li>at the <strong>local level</strong>, the objective is to support
                        the effective <strong>collection</strong> of the microdata
                        required by the aggregated statistics.</li>
                </ol>
            </div>
        </div>

        <div id="statbar">
            <?php include "/screens/websig/explore_indicador.php" ?>
        </div>


        <div id="layerProperties">
            <h4><?= R('Layer Properties') ?></h4>
            <div id="layerProperty">
            </div>
            <p><a href="#" btnaction="true" class="btn btn-default btn-xs" onclick="layerPropertiesBar.hide();"><?= R("l_close") ?></a> </p>
        </div>



        <div id="loading">
            <div class="loading-indicator">
                <div class="progress progress-striped active">
                    <div class="progress-bar progress-bar-info" style="width: 100%"></div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="exportMapModal" tabindex="-1" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title">Export Map<?= R('l_Export_map') ?></h4>
                    </div>
                    <div class="modal-body">
                        <p>Export map UI ...</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="featureModal" tabindex="-1" role="dialog">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button class="close" type="button" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title text-primary" id="feature-title"></h4>
                    </div>
                    <div class="modal-body" id="feature-info"></div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="addLayer" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <button class="close" type="button" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title"><?= R('l_add_layer') ?></h4>
                    </div>
                    <div class="modal-body">
                        <ul class="nav nav-tabs" id="addLayerTabs">
                            <li class="active"><a href="#addLayerCatalog" data-toggle="tab"><i class="fa fa-cloud-download"></i>&nbsp;<?= R('l_Add_layers_from_catalog_or_other_url') ?></a></li>
                            <!--<li><a href="#contact" data-toggle="tab"><i class="fa fa-cloud"></i>&nbsp;<?= R('l_add_service_layer') ?></a></li>-->
                            <!--<li><a href="#localdata" data-toggle="tab"><i class="fa fa-exclamation-circle"></i>&nbsp;Add Local Data</a></li>-->
                        </ul>

                        <div class="tab-content" id="addLayerTabsContent">
                            <div class="tab-pane fade active in" id="addLayerCatalog">
                                <p>
                                    <?php include "/screens/websig/catalog.php" ?>
                            </div>
                            <div class="tab-pane fade" id="contact">
                                <div class="row">					 
                                    <div class="col-sm-3">
                                        <label>Type</label>
                                        <select id="serviceType" class="form-control">
                                            <option value="wms" selected="selected">WMS</option>
                                            <option value="wmts">WMTS</option>
                                        </select>
                                    </div>
                                    <div class="col-sm-3">
                                        <label>Version</label>
                                        <select id="serviceVersion" class="form-control">
                                            <option value="1.1.1" selected="selected">1.1.1</option>
                                            <option value="1.3.0">1.3.0</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <label>Url</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="wmsUrl">
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-default" id="btnWMS">
                                                    <span class="fa fa-list"></span> <?= R('l_get_layers') ?>
                                                </button>

                                            </span>
                                        </div>
                                    </div> 
                                </div>
                                <div class="row">
                                    <div id="div-wms-results-glass"></div>
                                    <div class="col-sm-12" id="div-wms-results">
                                        <table class="table table-bordered table-striped" id="table-wms-results">
                                            <tr>
                                                <td></td>
                                            </tr>
                                        </table>
                                    </div>					
                                </div>

                            </div>


                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?= R('l_close') ?></button>
                    </div>
                </div>
            </div>
        </div>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/js/jquery-1.11.0.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/js/bootstrap.min.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/typeahead/typeahead.bundle.min.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-0.7.2/leaflet.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-sidebar/L.Control.Sidebar.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-TileLayer-WMTS/leaflet-tilelayer-wmts-src.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.imageoverlay.wms.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.markercluster/leaflet.markercluster-src.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/jquery-block-ui/jquery.blockUI.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-easyPrint/jQuery.print.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet-easyPrint/leaflet.easyPrint.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/extendedLayerControl/src/extendedLayerControl.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/ol2/OpenLayers.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/ol2/wms/v1_1_1_INSPIRE.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/ol2/wms/v1_3_0_INSPIRE.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/ol2/wfs/v1_1_0_INSPIRE.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/ol2/wfs/v2_0_0_INSPIRE.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.measure/leaflet.measure.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/leaflet.measure/leaflet.measure_a.js"></script>


        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/spectrum/spectrum.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/xslt/xslt.js"></script>

        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/geoserv.js"></script>
        <script src="<?= __SITEBASE ?>/theme/<?= __THEME ?>/resources/websig/mosy.js"></script>


        <script type="text/javascript">
                var geoserver_url =<?php echo json_encode(WEBSIG_GEOSERVER_URL); ?>;
                var geonetwork_url =<?php echo json_encode(WEBSIG_GEONETWORK_URL); ?>;
        </script>



    </body>
</html>



<?php
// TODO: have geonameID parameter
if (isset($_GET['geonameID'])) {
    //LibWebsig::gotoGeonamePlace($_GET['geonameID']);
    echo '
        <script>
            alert();
        </script>
    ';
}

// zoom to 
if (isset($_GET['zoom']) and ( !isset($_GET['lat']) or ! isset($_GET['lng']))) {
    //LibWebsig::gotoGeonamePlace($_GET['geonameID']);
    $zoom = $_GET['zoom'];
    echo ("
        <script>
        $(document).ready(function() {
            mapZoom($zoom);
                })
        </script>
    ");
}


if (isset($_GET['lat']) and isset($_GET['lng'])) {
    $lat = $_GET['lat'];
    $lng = $_GET['lng'];
    $zoom = $_GET['zoom'];
    if ($zoom == "") {
        $zoom = 1;
    };

    echo ("
        <script>
        $(document).ready(function() {
            mapLatLong($lat,$lng,$zoom);
                })
        </script>
    ");


    if (isset($_GET['marker'])) {
        echo ("
        <script>
        $(document).ready(function() {
            pinMarker($lat,$lng);
                })
        </script>
    ");
    }
}

// to create a marker
if (isset($_GET['markLat']) and isset($_GET['markLng'])) {
    $lat = $_GET['markLat'];
    $lng = $_GET['markLng'];
    echo ("
        <script>
        $(document).ready(function() {
            pinMarker($lat,$lng);
                })
        </script>
    ");
}
?>