<?php 
/**
 * Screen provisionagreement\detail
 * @version 1.0.1
 * @package Backend\DataStructures
 * 
*/
$organisation_list = $this->data['organisation_list'];
$dpa = $this->data['dpa'];
$version = $this->data['version'];
$listldp = $this->data['listldp'];
$lfrequency = $this->data['lfrequency'];
$page = $this->data['page'];
$cangolive = $this->data['cangolive'];
$candisable = $this->data['candisable'];
$lreliability = $this->data['lreliability'];
$isdraft = $this->data['isdraft'];
$saveasnew = $this->data['saveasnew'];

$action = "new";
if ($page=="victims") {
	$stattypeid = __STATISTICAL_TYPE_VICTIMS;
} else {
	$stattypeid = __STATISTICAL_TYPE_TRAFFICKERS;
}

if ($dpa->id) {

	$action = "edit";
}

?>

<script>

function toggleAction(action) {
	if (action == 'create' || action == 'save')
	{
		$('#formdpa').attr('action','<?= __SITEBASE ?>/provisionagreement/'+action);
	}

}

$(document).ready(function() {
	   
    $('#validfrom').Zebra_DatePicker({default_position:"below",readonly_element:false});
    $('#validto').Zebra_DatePicker({default_position:"below",readonly_element:false});
    $('#publicationdeadline').Zebra_DatePicker({default_position:"below",readonly_element:false});

});

</script>

<div class="row" >
<div class="col-lg-12" >
<h3><?=  $page == "victims" ? R('page_title_victims_provisionagreement') : R('page_title_traffickers_provisionagreement') ?></h3>
<p>&nbsp;</p>
<?php $this->load('common/message',$this) ?>

<form id="formdpa" class="form-horizontal" action="<?= __SITEBASE ?>/provisionagreement/<?= $action == "new"  ? "create" : "save" ?>"  method="post">
	<input type="hidden" name="statisticaltype" value="<?= $stattypeid?>"/>

	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
	<?php
		$label = R('name');

		$name  = ($dpa != null)?"description" : 'name' ;
		$type  = 'text';
	?>
					
	<div class="form-group">
    	<label class="col-sm-2 control-label"><?=  htmlentities($label) ?>:</label>
    	<div class="col-sm-5">
        	<input type="text" required class="form-control" id="<?=$name ?>" name="<?=$name ?>" maxlength="150" placeholder="<?= R('name') ?>" value="<?= val($dpa,$name) ?>">
        </div>
   	</div>
 	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
    <div class="form-group">
   		<label class="col-sm-2 control-label"><?=  R('label_organization') ?>:</label>
   		<div class="col-sm-5">
    		<select class="form-control" name="fromorganisationid" id="fromorganisationid" required >
    		<option value="" style="display: none;"><?= R("label_please_select_dropdown") ?>
    		<?php foreach($organisation_list as $org) {
    			if ($org->id != __DATA_COLLECTOR_ORGANISATION) { ?>
	    			<option <?= (val($dpa,"fromorganisationid") == $org->id) ? "selected" : "" ?> value="<?= $org->id ?>"><?= $org->organisationname ?></option>
    		<?php } else {
    				$toOrg = $org->organisationname; 
    			  }
    			}?>
    		</select>
    		
    	</div><div style="margin-top:7px;"><?= R("label_helper_to") ?>&nbsp;&nbsp;<?= $toOrg ?></div>
    </div> 
    
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
    <?php
		$name  = 'validfrom';
		$type  = 'date';
	?>    
    <div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_from') ?>:</label>
    	<div class="col-sm-2">
		<input required type="text" name="validfrom" id="validfrom" value="<?= val($dpa,$name) ?>" class="form-control" placeholder="YYYY-MM-dd">
		</div>
	</div>
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
	<?php
		$name  = 'validto';
		$type  = 'date';
	?> 	
	<div class="form-group">
		<label class="col-sm-2 control-label"><?= R('label_to') ?>:</label>
		<div class="col-sm-2">
  		<input required type="text" id="<?=$name ?>" name="<?=$name ?>" value="<?=val($dpa,$name) ?>" class="form-control" placeholder="YYYY-MM-dd">
  		</div>
	</div>   
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_ldp_victims') ?>:</label>
    	<div class="col-sm-5">
       		 <select  required class="form-control" name="datastructuredefinitionid" id="datastructuredefinitionid" >
				<option value="" style="display: none;"><?= R("label_please_select_dropdown") ?></option>
    		<?php foreach($listldp as $ldp) { ?>
	    			<option <?= (val($dpa,"datastructuredefinitionid") == $ldp->datastructuredefinitions_id) ? " selected " : "" ?> value="<?= $ldp->datastructuredefinitions_id ?>"><?= $ldp->dsddesccodeversion ?></option>
    		<?php }?>
    		</select>
        </div>
   	</div>
 	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
   	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_frequency') ?>:</label>
    	<div class="col-sm-3">
       		 <select required class="form-control" name="frequencycodeid" id="frequencycodeid" onchange="">
				<option value="" style="display: none;"><?= R("label_please_select_dropdown") ?></option>
    		<?php foreach($lfrequency as $frq) { ?>
	    			<option <?= ( val($dpa,"frequencycodeid") == $frq->id) ? " selected " : "" ?> value="<?= $frq->id ?>"><?= print_field(D($frq->descriptioncode),'text') ?></option>
    		<?php }?>
       		     		</select>
        </div>
   	</div>
 	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
     <?php
		$name  = 'publicationdeadline';
		$type  = 'date';
	?>    	
   	<div class="form-group">
		<label class="col-sm-2 control-label"><?= R('label_submition_start') ?>:</label>
		<div class="col-sm-2">
  			<input required type="text" id="<?=$name ?>" name="<?=$name ?>" value="<?= val($dpa,$name) ?>" class="form-control" placeholder="YYYY-MM-dd" value="val($dpa,$name) ?>">
  		</div>
	</div> 
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
	<?php
		$name  = 'embargotime';
		
	?> 	 
		<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_embargo') ?>:</label>
    	<div class="col-sm-2">
        	<input required type="number" min="0" max="12"  id="<?=$name ?>" name="<?=$name ?>" value="<?= val($dpa,$name) ?>" class="form-control" placeholder="0" value="val($dpa,$name) ?>">
        </div><div style="margin-top:7px;"><?= R("label_helper_embargo_unit") ?></div>
         
   	</div>
	
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
   	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_reliability') ?>:</label>
    	<div class="col-sm-5">
       		 <select required class="form-control" name="reliabilitycodeid" id="reliabilitycodeid" onchange="">
 				<option value="" style="display: none;"><?= R("label_please_select_dropdown") ?></option>
    		<?php foreach($lreliability as $rel) { ?>
	    			<option <?= (val($dpa,"reliabilitycodeid") == $rel->id) ? " selected " : "" ?> value="<?= $rel->id ?>"><?= print_field(D($rel->descriptioncode),'text') ?></option>
    		<?php }?>
    		</select>
        </div>
   	</div> 
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
   	<?php
		$label = R('description');
		$name  = 'annotation';
		$type  = 'text';
		$val =  val($version,$name);
	?>   	
   	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= htmlentities($label) ?>:</label>
    	<div class="col-sm-5">
    		<textarea class="form-control" maxlength="255" class="form-control" name="<?= $name ?>" placeholder="<?= $label ?>" ><?= ($val) ? $val : "" ?></textarea>
    	</div>
   	</div>
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
   	<?php
		$label = R('version');
		$name  = 'code';
		$type  = 'text';
		$val =  val($version,$name);
	?>   	 
   	<div class="form-group">
		<label class="col-sm-2 control-label"><?= htmlentities($label) ?>:</label>
		<div class="col-sm-2">
  			<input required type="text"   maxlength="20"  class="form-control" name="<?= $name ?>" placeholder="<?= $label ?>" value="<?= $val ?>">
  		</div>
	</div>  
	<!------------------------------------------------------------------------------------------->
	<!------------------------------------------------------------------------------------------->
	<?php
		$label = R('status');
		$name  = 'status';
		$type  = 'text';

		$lactive = ($dpa->active == 1) ? R('active'): R('inactive');
		
		$saveState = ($action =="new") ? ' ' : (($isdraft)? '' : ' disabled="disabled" ');
		$savenewversionState = ($action =="new") ? ' disabled="disabled" ' :  '';
		$liveState = ($action =="new") ? ' disabled="disabled" ' : (($cangolive)? '' : ' disabled="disabled" ');
		$disableState = ($action =="new") ? ' disabled="disabled" ' : (($candisable)? '' : ' disabled="disabled" ');
			
		$onc_new = ($action =="new") ? '' : " onclick=\"toggleAction('save'); \" ";
		$onc_newversion = ($action =="new") ? '' : " onclick=\"toggleAction('create'); \" ";
			
		$onc_golive = ($cangolive) ? " onclick=\"window.location.href='".__SITEBASE."/provisionagreement/golive?id=".$dpa->id."&statisticaltype=". $stattypeid."'\" " : "";
		$onc_disable = ($candisable) ? " onclick=\"window.location.href='".__SITEBASE."/provisionagreement/disable?id=".$dpa->id."&statisticaltype=". $stattypeid."'\" " : "";		
		
	?>
	<div class="form-group">
		<label class="col-sm-2 control-label"><?= htmlentities($label) ?>:</label>
		<div class="col-sm-2" style="margin-top:8px;">
  			<?= $lactive ?>
  		</div>
	</div>
	<p>&nbsp;</p>
	<div style="margin-left: 17%">
	    	<?php if ($action == "edit") { ?>
				<input type="hidden" name="id" value="<?= $dpa->id ?>">
 			<?php } ?>

     	<button type="submit" class="btn btn-default" name="save" <?= $onc_new?> <?=$saveState ?>><?= R('btn_save') ?></button>
        <button type="submit" class="btn btn-default" name="savenewversion" <?= $onc_newversion?> <?=$savenewversionState ?>><?= R('btn_savenewversion') ?></button>
       	<a href="#" permissions="true" btnaction="true" class="btn btn-default" <?= $onc_golive?> <?= $liveState ?>><?= R("btn_golive") ?></a>&nbsp;
    	<a href="#" permissions="true" btnaction="true" class="btn btn-default" <?= $onc_disable?> <?= $disableState ?>><?= R("btn_disable") ?></a>&nbsp;
    			  
		<a href="<?= __SITEBASE ?>/provisionagreement/<?=$page ?>" class="btn btn-default" ><?= R('btn_cancel') ?></a>
			
	</div>
</form>


</div>
</div>