<?php 
/**
 * Screen organizations\detail
 * @version 1.0.1
 * @package Backend\Organisations
 * 
*/
$org = $this->data['org'];
$lang_list = $this->data['lang_list'];
$user_list = $this->data['user_list'];
$orgtype_list = $this->data['orgtype_list'];
$orgtypes = $this->data['orgtypes'];
$regtype_list = $this->data['reg_list'];
$listDPA = $this->data["listdpa"];
$action = "new"; 
$desc_dpa_v = "";
$desc_dpa_t = "";

if($org->active===false){
    $btn= 'disabled="disabled"';
}else {
    $btn='';
}
        $value = 0;
        if (isset($listDPA)) {

                $value = $org->id;
                $dpaFound = array_filter(
                $listDPA,
                    function ($e) use (&$value) { return $e->provisionagreements_fromorganisationid ==$value; }
                );

                foreach ($dpaFound as $dpa) {

                    if ($dpa->datastructuredefinitions_statisticaltypeid == __STATISTICAL_TYPE_TRAFFICKERS) {
                            $desc_dpa_t = $dpa->padesccodeversion;
                    }
                    if ($dpa->datastructuredefinitions_statisticaltypeid == __STATISTICAL_TYPE_VICTIMS) {
                            $desc_dpa_v = $dpa->padesccodeversion;
                    }
                }

        } 
if ($org->id) {
	
	$action = "edit";
}
 if($org->active==FALSE || !empty($user_list) || !empty($desc_dpa_t) || !empty($desc_dpa_v) || Authorization::context_access_mode() == __ACCESS_READ) {
             $button_status='disabled="disabled"';
        }

        
      
?>
<div class="row" >
<div class="col-lg-12" >
<h3><?=R('page_organisation_title') ?></h3>
<div class="panel panel-default">
 <div class="panel-body">
	<h4><?= R('label_new_organisation') ?></h4>
</div>
</div>
<?php $this->load('common/message',$this) ?>

<div class="panel panel-default">
<div class="panel-body">
<form class="form-horizontal" action="<?= __SITEBASE ?>/organizations/<?= $action == "new" ? "create" : "save" ?>"  method="post">
	<div class="form-group">
    	<label class="col-sm-2 control-label"><?= R('label_organisationname') ?>:</label>
    	<div class="col-sm-5">
        	<input type="text" required class="form-control" maxlength="150" name="organisationname" placeholder="<?= R('label_organisationname') ?>" value="<?= val($org,'organisationname') ?>">
        </div>
   	</div>
   	<div class="form-group">
   		<label class="col-sm-2 control-label"><?= R('label_internationalname') ?>:</label>
   		<div class="col-sm-5">
    		<input type="text" required class="form-control"  maxlength="150" name="internationalname" placeholder="<?= R('label_internationalname') ?>" value="<?= val($org,'internationalname') ?>">
    	</div>
    </div>
    
    <div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_registeringtype') ?>:</label>
   		<div class="col-sm-5">
			 <select name="registercodeid" <?= (in_array(2,$orgtypes)) ? "required":"" ?> class="form-control">
				 <option  value="" style="display: none;"><?= R("label_please_select_dropdown") ?>
			 	<?php foreach($regtype_list as $registercodeType) { ?>
			 		<option <?= ($org->registercodeid == $registercodeType->id) ? "selected":"" ?> value="<?= $registercodeType->id ?>"><?= D($registercodeType->descriptioncode) ?></option>
			 	<?php }?>
			 </select>
   		</div>
    </div>
    
	<div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_organisationtype') ?>:</label>
   		<div class="col-sm-5">
			 <select <?= $action=="edit" ? "disabled":"" ?> name="organisationtype[]" multiple class="form-control">
			 	<?php foreach($orgtype_list as $orgtype) { ?>
			 		<option <?= $orgtypes ? (in_array($orgtype->id,$orgtypes) ? "selected":""):"" ?> value="<?= $orgtype->id ?>"><?= D($orgtype->descriptioncode) ?></option>
			 	<?php }?>
			 </select>
   		</div>
    </div>
   	<div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_language') ?>:</label>
   		<div class="col-sm-5">
			 <select name="languageid" class="form-control" required>
			 	<option value="" style="display: none;"><?= R("label_please_select_dropdown") ?>
			 	<?php foreach($lang_list as $lang) { ?>
                                    <option <?= ($org->languageid == $lang->id) ? "selected":"" ?> value="<?= $lang->id ?>"><?= D($lang->descriptioncode) ?></option>
                                   
			 	<?php }?>
			 </select>
    	</div>
   	 </div>
   	 <?php if ($action=="edit") {?>
     <div class="form-group ">
   		<label class="col-sm-2 control-label"><?= R('label_user') ?>:</label>
   		<div class="col-sm-5">
			 <select name="userid" class="form-control">
			 	<option value=""  style="display: none;"><?= R("label_please_select_dropdown") ?>
			 	<?php foreach($user_list as $user) { ?>
			 		
                                        <option <?= ($org->userid == $user->id) ? "selected":"" ?> value="<?= $user->id ?>"><?= $user->fullname ?></option>
			 	<?php }?>
			 </select>
    	</div>
    </div>
    <?php }?>
    <p>&nbsp;</p>
    <div class="col-sm-7">
    <div class="pull-right">
    	
    	<?php if ($action == "edit") { ?>
    		<input type="hidden" name="id" value="<?= $org->id ?>">
    	<?php } ?>
        <button type="submit" <?php echo $btn;?> class="btn btn-default" name="submit"><?= R('btn_save') ?></button>
     
    <a id="disable" href='<?= __SITEBASE ?>/organizations/disable?id=<?= $org->id ?>' <?= $button_status;?>  class="btn btn-default" ><?= R('btn_disable') ?></a>

 <a id="delete" href="<?= __SITEBASE ?>/organizations/delete?id=<?= $org->id ?>" <?= $button_status;?> class="btn btn-default" role="button"><?= R("btn_delete") ?></a>
    <a href="<?= __SITEBASE ?>/organizations" class="btn btn-default" role="button"><?= R("btn_cancel") ?></a>
    </div>
    </div>

</form>
</div>
</div>
</div>
</div>


<script>
<?php if ($org->id == 1) { ?>

$(document).ready(function() {
    $('input').attr('disabled','disabled');
    $('select').attr('disabled','disabled');
    $('textarea').attr('disabled','disabled');
    $('button').attr('disabled','disabled');
});	 

<?php  } ?>
$("#disable").click(function(){
    if(confirm("<?= R("label_confirm_disable_organization") ?>")){
        $("#disable").attr("href", '<?= __SITEBASE ?>/organizations/disable?id=<?= $org->id ?>');
    }
    else{
        return false;
    }
});
$("#delete").click(function(){
    if(confirm("<?= R("label_confirm_delete_organization") ?>")){
        $("#delete").attr("href", "<?= __SITEBASE ?>/organizations/delete?id=<?= $org->id ?>");
    }
    else{
        return false;
    }
});
</script>
