<?php
/**
 * Screen nfpcollect\index
 * @version 1.0.1
 * @package Backend\DataRecords
 * 
*/
require_once 'app/class-lov-manager.php';

$list = $this->data['list'];
$aset = $this->data['assistedSet'];
$setString = (!isset($aset)) ? "": implode(",",$aset);
$arules = $this->data['rules'];
$navurl = $this->data['navkey'];

$ifvoid = count($list) > 0 ? "": " DISABLED "; 

$lovmanager = new LovManager();
$sexlist = $lovmanager->getLov_Sex();
$agegroup = $lovmanager->getLov_AgeGroup();
$countries = $lovmanager->getLov_Countries();
$recordstatuslist = $lovmanager->getLov_RecordStatus();
$formsofexplotation = $lovmanager->getLov_FormOfExploitation();

$start_year= __SYSTEM_START_YEAR;

    function sortArray(&$array, $item)
    {  
        $result_array = array();
            foreach ($array as $key => $row)
            {
                $result_array[$key] = $row->$item;
            }
          
                array_multisort($result_array, SORT_ASC , $array);
    }
        
    function sortCountryArray(&$array, $item) 
    {  
        $current_language = Session::get_language()->code;
        $result_array = array();
           
            foreach ($array as $key => $row)
            {           
                    $result_array[$key]  = D($row->$item);
                
            }
            if($current_language!='en_GB'){
                setlocale(LC_ALL, $current_language);
                sort( $result_array, SORT_LOCALE_STRING);
                
            }else {
                array_multisort($result_array, SORT_ASC , $array);
            }
    }
$simpleStatusList = array();
foreach ($recordstatuslist as $lc){
	$simpleStatusList[$lc->id] = $lc->descriptioncode;
}

?>
<div class="row" >
<div class="col-lg-12" >
            <h3><?= R('page_title_nfp_collectdata') ?></h3>
            <p>&nbsp;</p>
			<?php $this->load('common/message',$this) ?>
            
             <form class="form-inline" role="form" name="formcolnfp" id="formcolnfp" onsubmit="return validate_checks();" method="post" action="<?= __SITEBASE ?>/nfpcollect">
             <input type="hidden" id="tainted" name="tainted" value="0"></input>
             <input type="hidden" id="retnav" name="retnav" value="nfpcollect"></input>
             <input type="hidden" id="assistedset" name="assistedset" value="<?= $setString ?>"></input>
             <div class="panel panel-default">
		         <div class="panel-body">
			        
			         	 <div class="form-group">
			          	<?= R('label_gender') ?>:
			          
					  		<select name="gender" permissions="false" class="form-control">
					  		<option value=""></option>
					   		<?php  foreach($sexlist as $item) {  ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['gender'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   		<?php  } ?>
					   		</select>
					   </div>
					   <div class="form-group">
					   <?= R('label_birthdate') ?>:
					   <input type="text" name="birthdate"  permissions="false" id="birthdate" value="<?= $_POST['birthdate'] ?>" class="form-control" placeholder="">
					  </div>
					  <div class="form-group">
					  <?= R('label_agegroup') ?>:
					  <select name="agegroup" permissions="false" class="form-control">
					  		<option value=""></option> 
					   <?php  
                                           sortArray($agegroup, 'code');
                                           foreach($agegroup as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['agegroup'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					  <?= R('label_type') ?>:
					  <select name="type" permissions="false" class="form-control">
							<option value="<?= __STATISTICAL_TYPE_VICTIMS ?>" <?= ($_POST['type'] == __STATISTICAL_TYPE_VICTIMS || $_POST['type']== "") ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></option>					  		
					  		<option value="<?= __STATISTICAL_TYPE_TRAFFICKERS ?>" <?= ($_POST['type'] == __STATISTICAL_TYPE_TRAFFICKERS ) ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) ?></option>
					   </select>
					  </div>
					  <div class="form-group">
					  <?= R('label_citizenship') ?>:
					  <select name="citizenship" permissions="false" class="form-control">
					  		<option value=""></option> 
					   <?php  
                                           sortCountryArray($countries, 'descriptioncode');
                                           foreach($countries as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['citizenship'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_countrybirth') ?>:
					  <select name="countrybirth" permissions="false" class="form-control">
					  		<option value=""></option> 
					   <?php  
                                            sortCountryArray($countries, 'descriptioncode');
                                            foreach($countries as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['countrybirth'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_year') ?>:
					  <select name="year" permissions="false" class="form-control">
					  		<option value=""></option> 
					   <?php  for($i= __SYSTEM_START_YEAR;$i<=date('Y');$i++) { ?>
					   		<option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_formofexplotation') ?>:
					  <select name="formofexplotation" permissions="false" class="form-control">
					  	<option value=""></option> 
					  	  <?php sortArray($formsofexplotation, 'code');
                                                        foreach($formsofexplotation as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['formofexplotation'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_recordstatus') ?>:
					  <select name="recordstatus" permissions="false" class="form-control">
					  	<option value=""></option> 
					  	  <?php  foreach($recordstatuslist as $item) {
                                                     if(!isset($_POST['recordstatus'])){
                                                          $initial_status = __RECORD_STATUS_UNCOMPLETED;
                                                      }else {
                                                          $initial_status = $_POST['recordstatus'];
                                                      }
                                                    ?>
                                                        
					   		<option value="<?= $item->id ?>" <?= ($initial_status == $item->id) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
	             </div>
             </div>
            <button type="submit" permissions="false" onclick="toggleAction('filter')" class="btn btn-default"><?=R('label_filter') ?></button>
			<a href="#" btnaction="true" class="btn btn-default" onclick="clean();"><?= R("label_clear") ?></a>
			

            <div class="panel" style="margin-top:20px;">
	             <div class="panel panel-default">
			         <div class="panel-body">
			           	 <div class="table-responsive" >
				              <table class="table table-hover table-striped tablesorter">
				                <thead>
				                  <tr>
				                  	<th class=""></th>
				                    <th class="header"><?= R('label_UID') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_type') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_cluster') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_organization') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_status') ?> <i class="fa fa-sort"></i></th>
				                  </tr>
				                </thead>
				                <tbody>
				                <?php foreach($list as $line) { ?>
				                 <tr class="annotation" title="<?=$line->annotation ?>">
				                    <td><input name="ck_<?= $line->uid ?>" type="checkbox" <?= ($_POST['ck_'.$line->uid] != null)? " checked " :"" ?>></td>
				                    <td><a href="<?= __SITEBASE ?>/recorddetail?uid=<?= $line->uid ?>&<?=$navurl ?>"><?= $line->uid ?></a></td>
				                    <td><?= ($line->type == __STATISTICAL_TYPE_TRAFFICKERS) ? D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) : D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></td>
				                    <td><a href="<?= __SITEBASE ?>/clusterdetail?cid=<?= $line->cluster ?>&<?=$navurl ?>"><?= $line->cluster ?></a></td>
				                    <td><?= $line->organisation ?></td>
				                    <td><?= D($simpleStatusList[$line->status]) ?></td>
				                 </tr>
				               <?php }?>
				                </tbody>
				              </table>
		            
			              </div>
			              
		              </div>
		               
	              </div>

			            <button style="padding-left:20px;" type="submit" onclick="toggleAction('compare')" class="btn btn-default checkboxdependent" <?= $ifvoid ?>><?=R('label_compare') ?></button>
						<button style="padding-left:20px;" type="submit" onclick="toggleAction('cluster')" class="btn btn-default checkboxdependent" <?= $ifvoid ?>><?=R('label_newcluster') ?></button>
						<button style="padding-left:20px;" type="submit" onclick="toggleAction('exportexcel')" class="btn btn-default checkboxdependent" <?= $ifvoid ?>><?=R('label_exportexcel') ?></button>
						<!-- <button style="padding-left:20px;" type="submit" class="btn btn-default" <?= $ifvoid ?>><?=R('label_cancel') ?></button> -->
						<span class="pull-right">
						<select id="ruleid" name="ruleid" style="margin-left:50px;width:300px" name="" class="form-control" <?= $ifvoid ?>>
							<?php  foreach($arules as $item) { ?>
							<option value="<?= $item->id ?>"  <?= ($_POST['ruleid'] == $item->id) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
							<?php  } ?>
						</select>
						<button style="padding-left:20px;" type="submit" class="btn btn-default" onclick="runRule();" <?= $ifvoid ?>><?=R('label_run') ?></button>
					</span>

				</form>
            </div>

</div>
  <script>
 $(document).ready(function() {
	    $('#birthdate').Zebra_DatePicker({default_position:"below",readonly_element:false});
});

function clean() {

	$('#birthdate').val('');
	$('select option:selected').removeAttr('selected');
}


function runRule(){
	$('#formcolnfp').attr('action','<?= __SITEBASE ?>/nfpcollect/runrule');
}

function toggleAction(action) {

	$('#tainted').val('1');

	if (action == 'filter')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/nfpcollect');
	}
	
	if (action == 'cluster')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/clusterdetail/newcluster');
	}
	if (action == 'compare')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/comparerecords/');
	}
	if (action == 'exportexcel')
	{
		$('#formcolnfp').attr('action','<?= __SITEBASE ?>/nfpcollect/exportexcel/');
	}
}

function validate_checks() {

	if ($('#tainted').val() == '1')
	{
		if (1==1) {
			return true;
		}
		else {
			$('#tainted').val('0');
		 	$("#formcolnfp").attr("action",'<?= __SITEBASE ?>/nfpcollect');
			return false;
		}
	}
}


//enable and disable buttons dependent off checkboxes
$(document).ready(function() {
	$(".checkboxdependent").prop('disabled', true);

	$("[type=checkbox]").bind("click",function(){
	
		if($("[type=checkbox]:checked").length == 0) {
			$(".checkboxdependent").prop('disabled', true);
		} else {
			$(".checkboxdependent").prop('disabled', false);;
		}
		
	});
});
//-----------------------------------------------------------


 </script>   