<?php
/**
 * Screen nfpanalyse\index
 * @version 1.0.1
 * @package Backend\DataRecords
 * 
*/
require_once 'app/class-lov-manager.php';

$list = $this->data['list'];
$arules = $this->data['rules'];
$navurl = $this->data['navkey'];

//print_r($list);

$lovmanager = new LovManager();
$sexlist = $lovmanager->getLov_Sex();
$agegroup = $lovmanager->getLov_AgeGroup();
$countries = $lovmanager->getLov_Countries();
$formsofexplotation = $lovmanager->getLov_FormOfExploitation();
$recordstatuslist = $lovmanager->getLov_RecordStatus();

$simpleStatusList = array();
foreach ($recordstatuslist as $lc){
	$simpleStatusList[$lc->id] = $lc->descriptioncode;
}
function sortArray(&$array, $item)
    {  
        $result_array = array();
            foreach ($array as $key => $row)
            {
                $result_array[$key] = $row->$item;
            }
          
                array_multisort($result_array, SORT_ASC , $array);
    }
        
    function sortCountryArray(&$array, $item) 
    {  
        $current_language = Session::get_language()->code;
        $result_array = array();
           
            foreach ($array as $key => $row)
            {           
                    $result_array[$key]  = D($row->$item);
                
            }
            if($current_language!='en_GB'){
                setlocale(LC_ALL, $current_language);
                sort( $result_array, SORT_LOCALE_STRING);
       
            }else {
                array_multisort($result_array, SORT_ASC , $array);
            }
    }
?>
<div class="row" >
<div class="col-lg-12" >
            <h3><?= R('page_title_nfp_analysedata') ?></h3>
            <p>&nbsp;</p>
			<?php $this->load('common/message',$this) ?>
            
             <form class="form-inline" role="form" name="formanlnfp" id="formanlnfp" method="post" action="<?= __SITEBASE ?>/nfpanalyse">
             <input type="hidden" id="retnav" name="retnav" value="nfpanalyse"></input>
             <div class="panel panel-default">
		         <div class="panel-body">
			        
			         	 <div class="form-group">
			          	<?= R('label_gender') ?>:
			          
					  		<select name="gender" class="form-control">
					  		<option value=""></option> 
					   		<?php  foreach($sexlist as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['gender'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   		<?php  } ?>
					   		</select>
					   </div>
					   <div class="form-group">
					   <?= R('label_birthdate') ?>:
					   <input type="text" name="birthdate"  id="birthdate" value="<?= $_POST['birthdate'] ?>" class="form-control" placeholder="">
					  </div>
					  <div class="form-group">
					  <?= R('label_agegroup') ?>:
					  <select name="agegroup" class="form-control">
					  		<option value=""></option> 
					   <?php  sortArray($agegroup, 'code');
                                           foreach($agegroup as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['agegroup'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					  <?= R('label_type') ?>:
					  <select name="type" class="form-control">
							<option value="<?= __STATISTICAL_TYPE_VICTIMS ?>" <?= ($_POST['type'] == __STATISTICAL_TYPE_VICTIMS || $_POST['type']== "") ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></option>					  		
					  		<option value="<?= __STATISTICAL_TYPE_TRAFFICKERS ?>" <?= ($_POST['type'] == __STATISTICAL_TYPE_TRAFFICKERS ) ? "selected" : "" ?>><?= D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) ?></option>
					   </select>
					  </div>
					  <div class="form-group">
					  <?= R('label_citizenship') ?>:
					  <select name="citizenship" class="form-control">
					  		<option value=""></option> 
					   <?php    sortCountryArray($countries, 'descriptioncode');
                                                    foreach($countries as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['citizenship'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_countrybirth') ?>:
					  <select name="countrybirth" class="form-control">
					  		<option value=""></option> 
					   <?php    sortCountryArray($countries, 'descriptioncode');
                                                    foreach($countries as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['countrybirth'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_year') ?>:
					  <select name="year" class="form-control">
					  		<option value=""></option> 
					   <?php  for($i=__SYSTEM_START_YEAR;$i<=date('Y');$i++) { ?>
					   		<option value="<?= $i ?>" <?= ($_POST['year'] == $i) ? "selected" : "" ?>><?= $i ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_formofexplotation') ?>:
					  <select name="formofexplotation" class="form-control">
					  	<option value=""></option> 
					  	  <?php  sortArray($formsofexplotation, 'code');
                                                  foreach($formsofexplotation as $item) { ?>
					   		<option value="<?= $item->code ?>" <?= ($_POST['formofexplotation'] == $item->code) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
					  <div class="form-group">
					   <?= R('label_recordstatus') ?>:
					  <select name="recordstatus" class="form-control">
					  	<option value=""></option> 
                                                    <?php  foreach($recordstatuslist as $item) {
                                                     if(!isset($_POST['recordstatus'])){
                                                          $initial_status = __RECORD_STATUS_COMPLETED;
                                                      }else {
                                                          $initial_status = $_POST['recordstatus'];
                                                      }
                                                    ?>
                                                        
					   		<option value="<?= $item->id ?>" <?= ($initial_status == $item->id) ? "selected" : "" ?>><?= D($item->descriptioncode) ?></option>
					   <?php  } ?>
					   </select>
					  </div>
	             </div>
             </div>
            <button type="submit" class="btn btn-default"><?=R('label_filter') ?></button>
			<a href="#" btnaction="true" class="btn btn-default" onclick="clean();"><?= R("label_clear") ?></a>
			

            <div class="panel" style="margin-top:20px;">
	             <div class="panel panel-default">
			         <div class="panel-body">
			           	 <div class="table-responsive" >
				              <table id="table1" class="table table-hover table-striped tablesorter">
				                <thead>
				                  <tr>
				                    <th></th>
				                    <th class="header"><?= R('label_UID') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_type') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_cluster') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_organization') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_status') ?> <i class="fa fa-sort"></i></th>
				                  </tr>
				                </thead>
				                <tbody>
				                <?php if(is_array($list)){foreach($list as $line) { ?>
				                 <tr class="annotation" title="<?=$line->annotation ?>">
				                    <td><input name="ck_<?= $line->uid ?>" type="checkbox"></td></td>
				                    <td><a href="<?= __SITEBASE ?>/recorddetail?uid=<?= $line->uid ?>&<?=$navurl ?>"><?= $line->uid ?></a></td>
				                    <td><?= ($line->type == __STATISTICAL_TYPE_TRAFFICKERS) ? D(__STATISTICAL_TYPE_TRAFFICKERS_DESCRITION) : D(__STATISTICAL_TYPE_VICTIMS_DESCRITION) ?></td>
				                    <td><a href="<?= __SITEBASE ?>/clusterdetail?cid=<?= $line->cluster ?>&<?=$navurl ?>"><?= $line->cluster ?></a></td>
				                    <td><?= $line->organisation ?></td>
				                    <td><?= D($simpleStatusList[$line->status]) ?></td>
				                 </tr>
                                                <?php }}?>
				                </tbody>
				              </table>
		            
			              </div>
			              
		              </div>
		               
	              </div>
              
            </div>
            <button style="padding-left:20px;" type="submit" onclick="toggleAction('exportexcel')" class="btn btn-default checkboxdependent" <?= $ifvoid ?>><?=R('label_exportexcel') ?></button>
            </form>	
</div>
</div>
  <script>
 $(document).ready(function() {
	    $('#birthdate').Zebra_DatePicker({default_position:"below",readonly_element:false});
});
 
function clean() {

	$('#birthdate').val('');
	$('select option:selected').removeAttr('selected');
}

function toggleAction(action) {
	
	if (action == 'exportexcel')
	{
		$('#formanlnfp').attr('action','<?= __SITEBASE ?>/nfpanalyse/exportexcel/');
	}
}


//enable and disable buttons dependent off checkboxes
$(document).ready(function() {
	$(".checkboxdependent").prop('disabled', true);

	$("[type=checkbox]").bind("click",function(){
	
		if($("[type=checkbox]:checked").length == 0) {
			$(".checkboxdependent").prop('disabled', true);
		} else {
			$(".checkboxdependent").prop('disabled', false);;
		}
		
	});
});
//-----------------------------------------------------------
 </script>   