<?php 
/**
 * Screen auditing\data
 * @version 1.0.1
 * @package Backend\Auditing
 * 
*/
$list = $this->data['list'];
$loglist= $this->data['loglist'];
$initdate = date('Y-m-d',$this->data['initdate']);
$enddate = date('Y-m-d',$this->data['enddate']);
?>
<div class="row" >
<div class="col-lg-12" >
            <h3><?= R('page_title_auditing_data') ?></h3>
             <div class="panel panel-default">
		         <div class="panel-body">
			         <form class="form-inline" role="form" name="form1" method="post" action="<?= __SITEBASE ?>/dataaudit">
                                     <div class="row">
                                      <div class="form-group col-md-3">
                                        <input type="text" name="init_date"   id="init_date" value="<?= $_POST['init_date'] ? $_POST['init_date'] : $initdate ?>" class="form-control" placeholder="<?= R('label_initdate') ?>">
                                        </div>   
                                      <div class="form-group col-md-3">
                                        <input type="text" name="end_date"  id="end_date" value="<?= $_POST['end_date'] ?  $_POST['end_date'] : $enddate  ?>" class="form-control" placeholder="<?= R('label_enddate') ?>">
                                       </div>    
                                      <div class="form-group col-md-3l">
                                            <input type="text" name="username" value="<?= $_POST['username'] ?>" class="form-control" placeholder="<?= R('label_username') ?>">
                                           </div>   
                                    <div class="form-group col-md-3">
						  <select  class="form-control" name="operation" placeholder="<?= label_operation ?>">
						  	<option value="">all operations</option>
						  	<option <?= $_POST['operation'] == "create" ? "selected":""?>>create</option>
						  	<option <?= $_POST['operation'] == "update" ? "selected":""?>>update</option>
						  	<option <?= $_POST['operation'] == "delete" ? "selected":""?>>delete</option>
						  	<option <?= $_POST['operation'] == "other" ? "selected":""?>>other</option>
						  </select>
						  </div>     
                                         
                                         
                                     </div>
                                     <div class="row">
                                     <div class="form-group col-md-3">
                                            <select  class="form-control" name="loglevel">
                                                <option value=""><?= R('all_levels') ?></option>
                                                <?php                                                           
                                                foreach ($loglist as $key => $value) { ?>
                                                <option value="<?= $value->id?>"<?= $_POST['loglevel'] == $value->id ? "selected":""?>><?= $value->valuetext;?></option>  
                                              <?php  }?>
                                            </select>
                                        </div>
                                     <div class="form-group col-md-3">
                                            <input type="text" name="context" value="<?= $_POST['context'] ?>" class="form-control" placeholder="<?= R('label_context') ?>">
                                          </div>  
                                        <div class="form-group"><input type="submit" name="submit" class="btn btn-default" value="<?=R('label_filter') ?>"></div>
					    
                                     </div>
		             </form>
	             </div>
             </div>
             <div class="panel">
	             <div class="panel panel-default">
			         <div class="panel-body">
			           	 <div class="table-responsive" >
			           	 
				              <table id="table1" class="table table-hover table-striped tablesorter">
				                <thead>
				                  <tr>
				                    <th class="header"><?= R('label_date') ?> <i class="fa fa-sort"></th>
				                    <th class="header"><?= R('label_username') ?> <i class="fa fa-sort"></i></th>
				                    <th class="header"><?= R('label_entity') ?> <i class="fa fa-sort"></th>
				                    <th class="header"><?= R('label_operation') ?> <i class="fa fa-sort"></th>
				                  </tr>
				                </thead>
				                <tbody>
				                <?php foreach($list as $line) { ?>
				                 <tr  class="annotation" title="<?=htmlentities ($line->valuetext) ?>">
				                    <td><?= to_datetime($line->timestamp) ?></td>
				                    <td><?= $line->username ?></td>
				                    <td><?= $line->entity ?></td>
				                    <td><?= $line->operation ?></td>
				                  </tr>
				               <?php }?>
				                </tbody>
				              </table>
		            
			              </div>
		              </div>
	              </div>
            </div>
       </div>
</div> 
<script>
$(document).ready(function() {
	    $('#init_date').Zebra_DatePicker({default_position:"below",readonly_element:false});
	    $('#end_date').Zebra_DatePicker({default_position:"below",readonly_element:false});
});






 </script>              