<?php
/**
 * Data Transaction  support
 *
 * granst transaction on DB via PDO
 *
 * @author ba - Advantis Solutions
 * @version 1.0.1
 * @package Base
 */
class Transaction {
	private static $handle = null;
	private static $on = false;
	
	/**
	 * constructor
	 */
	private function __construct() {
	}
	
	/**
	 * get on state
	 *
	 * @return boolean
	 */
	public static function isOn() {
		return self::$on;
	}
	
	/**
	 * get handle
	 *
	 * @return Ambigous <NULL, unknown>
	 */
	public static function getHandle() {
		return self::$handle;
	}
	
	/**
	 * marks begin transaction
	 */
	public static function beginTransaction() {
		self::$on = true;
	}
	
	/**
	 * sets handle
	 *
	 * @param unknown $handle        	
	 */
	public static function set_handle($handle) {
		self::$handle = $handle;
	}
	
	/**
	 * commits current transaction
	 */
	public static function commit() {
		self::$handle->commit ();
		self::finish ();
	}
	
	/**
	 * rollback current transaction
	 */
	public static function rollback() {
		self::$handle->rollback ();
		self::finish ();
	}
	
	/**
	 * finish and clean up
	 */
	public static function finish() {
		self::$handle = null;
		self::$on = false;
	}
}

?>