<?php
require_once 'app/class-language-manager.php';
require_once 'app/class-session.php';
require_once 'includes/data-access/class-transaction.php';

/**
 * Aplication context super class
 *
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Base
 *         
 */
class context {
	/**
	 *
	 * template name - default:"default"
	 * 
	 * @var string
	 *
	 */
	private $template = "default";
	/**
	 *
	 * screen name - default:"index"
	 * 
	 * @var unknown_type
	 */
	private $screen = 'index';
	/**
	 *
	 * Object that olds screen data
	 * 
	 * @var Object
	 */
	public $data;
	
	/**
	 * constructor
	 */
	function context() {
		Transaction::finish ();
	}
	
	/**
	 *
	 * Loads context screen action
	 * 
	 * @param string $screen        	
	 * @param object $data        	
	 * @param string $template        	
	 *
	 */
	function screen($screen = null, $data = null, $template = 'default') {
		$this->data = $data;
		
		$this->screen = $screen;
		
		if ($template) {
			$this->template = $template;
		}
		
		include 'theme/' . __THEME . '/template_' . $this->template . '.php';
	}
	/**
	 *
	 * Load
	 * 
	 * @param string $screen        	
	 */
	function load($screen = null) {
		if (! $screen) {
			$screen = $this->screen;
		}
		
		include "theme/" . __THEME . "/screens/" . $screen . ".php";
	}
}

?>