<?php
/**
 * Description of class-websigservices
 * @author Fred
 */
require_once "app/class-lov-manager.php";
require_once "app/class-version.php";
require_once "app/class-data-structures.php";
require_once "app/class-data-structures-questions.php";
require_once "app/class-data-structures-manager.php";

require_once "app/class-service-group.php";
require_once "app/class-service.php";

/**
 * websig services Context
 *
 * web SIG services operations
 * 
 * @author Fred - Advantis
 * @version 1.0.1
 * @package Backend\SIG
 */
class context_websigservices extends context {
	private $contextname = "websigservices";
	
	/**
	 * Constructor & Authorization
	 */
	function context_websigservices() {
		main::check_auth_session ();
	}
	
	/**
	 * default action
	 */
	function index() {
		$this->services ();
	}
	
	/**
	 */
	function services() {
		$em = new EntityManager ( 'services_types', 'WEBSIG' );
		$list_serv_type = $em->load ();
		
		$em = new EntityManager ( 'services_getfeatformat', 'WEBSIG' );
		$list_serv_getFeatFormat = $em->load ();
		
		$em = new EntityManager ( 'services_version', 'WEBSIG' );
		$list_serv_version = $em->load ();
		
		$em = new EntityManager ( 'services_imgformat', 'WEBSIG' );
		$list_serv_imgFormat = $em->load ();
		
		$em = new EntityManager ( 'services_groups', 'WEBSIG' );
		$list_owsgroups = $em->load ();
		
		// $em = new EntityManager('services', 'WEBSIG');
		// $list = $em->load();
		
		$da = new DataAccess ( 'WEBSIG' );

		$args = array();
		$sql = "SELECT s.*,sv_type.type_name,sv_version.version_name,sv_imgf.format_name,sv_gff.getfeatformat_name FROM geo.services s left join geo.services_types sv_type on (s.service_type = sv_type.id)" . " left join geo.services_version sv_version on (s.service_version = sv_version.id)" . " left join geo.services_imgformat sv_imgf on (s.service_imgformat = sv_imgf.id)" . " left join geo.services_getfeatformat sv_gff on (s.service_getfeatformat = sv_gff.id)";
		$r = $da->func_get ( $sql, $args );
		//$r = $da->query ( $sql );
		
		$list = array ();
		foreach ( $r as $line ) {
			$entity = new Entity ( 'services', null, 'WEBSIG' );
			
			foreach ( $line as $key => $value ) {
				$entity->$key = $value;
			}
			array_push ( $list, $entity );
		}
		
		// $this->screen("websigservices/index", array('page'=>'services','list' => $list));
		$this->screen ( $this->contextname . "/index_services", array (
				'page' => 'services',
				"list_owsgroups" => $list_owsgroups,
				"list_serv_type" => $list_serv_type,
				"list_serv_version" => $list_serv_version,
				"list_serv_imgFormat" => $list_serv_imgFormat,
				"list_serv_getFeatFormat" => $list_serv_getFeatFormat,
				"list" => $list,
				"contextname" => $this->contextname 
		) );
	}
	
	/**
	 */
	function servicesgroups() {
		$em = new EntityManager ( 'services_groups', 'WEBSIG' );
		$list = $em->load ();
		// $this->screen("websigservices/index", array('page'=>'services','list' => $list));
		$this->screen ( $this->contextname . "/index_groups", array (
				'page' => 'services_groups',
				"list" => $list,
				"contextname" => $this->contextname 
		) );
	}
	
	/**
	 */
	function save() {
		$em = new EntityManager ( 'services', 'WEBSIG' );
		$list = $em->load ();
		foreach ( $list as $obj ) {
			
			if ($_POST ['active_' . $obj->id]) {
				$obj->active = 1;
			} else {
				$obj->active = 0;
			}
			
			$obj->save ();
		}
		
		header ( 'Location:' . __SITEBASE . '/websigservices' );
	}
	
	/**
	 */
	function action() {
		switch ($_POST ['btnAction']) {
			case 'save' :
				$this->newgroup ();
				return;
			case 'delete' :
				$this->deletegroup ();
				return;
			case 'update' :
				$this->updategroup ();
				return;
			
			case 'ows_save' :
				$this->newows ();
				return;
			case 'ows_update' :
				$this->updateows ();
				return;
			case 'ows_delete' :
				$this->deleteows ();
		}
	}
	
	/**
	 */
	function newows() {
		if (! isset ( $_POST ['ows_active'] )) {
			$checkboxActive = 0;
		} else {
			$checkboxActive = 1;
		}
		
		if (! isset ( $_POST ['ows_owspublic'] )) {
			$checkboxPublic = 0;
		} else {
			$checkboxPublic = 1;
		}
		
		$em = new EntityManager ( 'services', 'WEBSIG' );
		
		$service = new Service ( null, "WEBSIG" );
		
		if ($_POST ["ows_name"]) {
			$service->service_name = $_POST ["ows_name"];
			$service->service_url = $_POST ["ows_url"];
			$service->group_name = $_POST ["ows_groupname"];
			$service->description = $_POST ["ows_description"];
			$service->active = $checkboxActive;
			$service->is_public = $checkboxPublic;
			
			$service->description = $_POST ["ows_description"];
			$service->metadata_url = $_POST ["ows_url_metadata"];
			$service->online_resource = $_POST ["ows_url_resource"];
			
			if (isset ( $_POST ['ows_serviceType'] )) {
				$service->service_type = $this->getServiceID ( $_POST ['ows_serviceType'] );
			} else {
				$service->service_type = null;
			}
			
			if (isset ( $_POST ['ows_serviceVersion'] )) {
				$service->service_version = $this->getVersionID ( $_POST ['ows_serviceVersion'] );
			} else {
				$service->service_version = null;
			}
			
			if (isset ( $_POST ['ows_serviceImgFormat'] )) {
				$service->service_imgformat = $this->getImgFormatID ( $_POST ['ows_serviceImgFormat'] );
			} else {
				$service->service_imgformat = null;
			}
			
			if (isset ( $_POST ['ows_serviceGetFeatFormat'] )) {
				$service->service_getfeatformat = $this->getFeatFormatID ( $_POST ['ows_serviceGetFeatFormat'] );
			} else {
				$service->service_getfeatformat = null;
			}
			
			$service = $em->create ( $service );
		}
		
		$this->services ();
	}
	
	/**
	 */
	function updateows() {
		if (! isset ( $_POST ['ows_active'] )) {
			$checkboxActive = 0;
		} else {
			$checkboxActive = 1;
		}
		
		if (! isset ( $_POST ['ows_owspublic'] )) {
			$checkboxPublic = 0;
		} else {
			$checkboxPublic = 1;
		}
		$service = new Service ( $_REQUEST ["id"], "WEBSIG" );
		
		$service->id = $_REQUEST ["id"];
		
		$service->service_name = $_POST ["ows_name"];
		$service->service_url = $_POST ["ows_url"];
		$service->group_name = $_POST ["ows_groupname"];
		$service->description = $_POST ["ows_description"];
		$service->active = $checkboxActive;
		$service->is_public = $checkboxPublic;
		$service->metadata_url = $_POST ["ows_url_metadata"];
		$service->online_resource = $_POST ["ows_url_resource"];
		
		if (isset ( $_POST ['ows_serviceType'] )) {
			$service->service_type = $this->getServiceID ( $_POST ['ows_serviceType'] );
		} else {
			$service->service_type = null;
		}
		
		if (isset ( $_POST ['ows_serviceVersion'] )) {
			$service->service_version = $this->getVersionID ( $_POST ['ows_serviceVersion'] );
		} else {
			$service->service_version = null;
		}
		
		if (isset ( $_POST ['ows_serviceImgFormat'] )) {
			$service->service_imgformat = $this->getImgFormatID ( $_POST ['ows_serviceImgFormat'] );
		} else {
			$service->service_imgformat = null;
		}
		
		if (isset ( $_POST ['ows_serviceGetFeatFormat'] )) {
			$service->service_getfeatformat = $this->getFeatFormatID ( $_POST ['ows_serviceGetFeatFormat'] );
		} else {
			$service->service_getfeatformat = null;
		}
		
		$service->save ();
		$this->services ();
	}
	
	/**
	 *
	 * @param unknown $type_name        	
	 */
	function getServiceID($type_name) {
		$em = new EntityManager ( 'services_types', 'WEBSIG' );
		$list_serv_type = $em->load ( "type_name like :type_name", array(':type_name' => $type_name ));
		$ent = $list_serv_type [0];
		return $ent->id;
	}
	
	/**
	 *
	 * @param unknown $version_name        	
	 */
	function getVersionID($version_name) {
		$em = new EntityManager ( 'services_version', 'WEBSIG' );
		$list_serv_type = $em->load ( "version_name like :version_name", array(':version_name' => $version_name) );
		$ent = $list_serv_type [0];
		return $ent->id;
	}
	
	/**
	 *
	 * @param unknown $format_name        	
	 */
	function getImgFormatID($format_name) {
		$em = new EntityManager ( 'services_imgformat', 'WEBSIG' );
		$list_serv_type = $em->load ( "format_name like :format_name", array(':format_name' => $format_name) );
		$ent = $list_serv_type [0];
		return $ent->id;
	}
	
	/**
	 *
	 * @param unknown $getFeatFormat_name        	
	 */
	function getFeatFormatID($getFeatFormat_name) {
		$em = new EntityManager ( 'services_getfeatformat', 'WEBSIG' );
		$list_serv_type = $em->load ( "getfeatformat_name like :getFeatFormat_name", array(':getFeatFormat_name' => $getfeatformat_name) );
		$ent = $list_serv_type [0];
		return $ent->id;
	}
	
	/**
	 */
	function deleteows() {
		$em = new EntityManager ( 'services', 'WEBSIG' );
		$service = new Service ( $_REQUEST ["id"], "WEBSIG" );
		$service->id = $_REQUEST ["id"];
		$service->delete ();
		
		$this->services ();
	}
	
	/**
	 */
	function updategroup() {
		$serviceGroup = new ServiceGroup ( $_REQUEST ["id"], "WEBSIG" );
		
		$serviceGroup->id = $_REQUEST ["id"];
		$serviceGroup->name = $_POST ["name"];
		$serviceGroup->description = $_POST ["description"];
		
		$serviceGroup->save ();
		
		$this->servicesgroups ();
	}
	
	/**
	 */
	function newgroup() {
		$em = new EntityManager ( 'services_groups', 'WEBSIG' );
		
		$serviceGroup = new ServiceGroup ( null, "WEBSIG" );
		
		if ($_POST ["name"]) {
			
			$serviceGroup->name = $_POST ["name"];
			$serviceGroup->description = $_POST ["description"];
			
			$serviceGroup = $em->create ( $serviceGroup );
		}
		
		$this->servicesgroups ();
	}
	
	/**
	 */
	function deletegroup() {
		$em = new EntityManager ( 'services_groups', 'WEBSIG' );
		$serviceGroup = new ServiceGroup ( $_REQUEST ["id"], "WEBSIG" );
		$serviceGroup->id = $_REQUEST ["id"];
		$serviceGroup->delete ();
		
		$this->servicesgroups ();
	}
	
	/**
	 * Ajax Support
	 */
	function get_lists() {
		// needed for ajax ?
	}
}

if (is_ajax ()) {
	if (isset ( $_POST ["action"] ) && ! empty ( $_POST ["action"] )) {
		$action = $_POST ["action"];
		switch ($action) {
			case "get_lists" :
				ows_getVersionList ( $_POST ["serviceType"] );
				break;
		}
	}
}

/**
 * Function to check if the request is an AJAX request
 *
 * @return boolean
 */
function is_ajax() {
	return isset ( $_SERVER ['HTTP_X_REQUESTED_WITH'] ) && strtolower ( $_SERVER ['HTTP_X_REQUESTED_WITH'] ) == 'xmlhttprequest';
}

/**
 * get services version, imgformat, feature_format by ows type
 *
 * @param unknown $ows_type        	
 */
function ows_getVersionList($ows_type) {
	$da = new DataAccess ( 'WEBSIG' );
	/*$sql = "SELECT version_name FROM geo.services_version sv
                    where service_type_id = (select id from geo.services_types where type_name like '$ows_type')
                    order by version_name";
	
	$r = $da->query ( $sql );*/

	$args = array();
	array_push ( $args, $da->helper_args ( 'ows_type', $ows_type, $da::TYPE_TEXT ) );
		
	$sql = "SELECT version_name FROM geo.services_version sv
                    where service_type_id = (select id from geo.services_types where type_name like :ows_type)
                    order by version_name";
		
	$r = $da->func_get ( $sql, $args );	
	
	$list = array ();
	
	$rec = array ();
	foreach ( $r as $line ) {
		foreach ( $line as $key => $value ) {
			$rec [$key] = $value;
		}
		array_push ( $list, $rec );
	}
	
	/*$sql = "SELECT format_name FROM geo.services_imgformat sf
                    where service_type_id = (select id from geo.services_types where type_name like '$ows_type')
                    order by format_name";
	$r = $da->query ( $sql );*/

	$args = array();
	array_push ( $args, $da->helper_args ( 'ows_type', $ows_type, $da::TYPE_TEXT ) );
		
	$sql = "SELECT format_name FROM geo.services_imgformat sf
                    where service_type_id = (select id from geo.services_types where type_name like :ows_type)
                    order by format_name";
		
	$r = $da->func_get ( $sql, $args );	

	$rec = array ();
	foreach ( $r as $line ) {
		foreach ( $line as $key => $value ) {
			$rec [$key] = $value;
		}
		array_push ( $list, $rec );
	}
	
	/*$sql = "SELECT getfeatformat_name FROM geo.services_getfeatformat sgff
                    where service_type_id = (select id from geo.services_types where type_name like '$ows_type')
                    order by id";
	$r = $da->query ( $sql );*/

	$args = array();
	array_push ( $args, $da->helper_args ( 'ows_type', $ows_type, $da::TYPE_TEXT ) );
		
	$sql = "SELECT getfeatformat_name FROM geo.services_getfeatformat sgff
                    where service_type_id = (select id from geo.services_types where type_name like :ows_type)
                    order by id";
		
	$r = $da->func_get ( $sql, $args );	

	$rec = array ();
	foreach ( $r as $line ) {
		foreach ( $line as $key => $value ) {
			$rec [$key] = $value;
		}
		array_push ( $list, $rec );
	}
	
	echo json_encode ( $list );
}

?>