<?php
require_once "app/class-recordset.php";

/**
 * Recordsets Context
 *
 * Context for Recordsets listing
 *
 * @author tmouzinho - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Recordsets
 */
class context_recordsets extends context {
	public $contextname = "recordsets";
	
	/**
	 * Constructor & Authorization
	 */
	function context_recordsets() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows cluster listing
	 */
	function index() {
		$item = new stdClass ();
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_GET );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		$em = new EntityManager ( Recordset::LISTVIEW );
		$list = $em->load ();
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'item' => $item1,
				'pvars' => $pvars,
				'navkey' => $navkey 
		) );
	}
}

?>