<?php
require_once "app/class-wf-engine.php";

/**
 * Context for record
 *
 * Supports record operations
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataRecords
 */
class context_recorddetail extends context {
	public $contextname = "recorddetail";
	
	/**
	 * Constructor method
	 *
	 * validates authorization for the user in session based on the current role
	 */
	function context_recorddetail() {
		main::check_auth_session ();
	}
	
	/**
	 * default action for this context
	 */
	function index() {
		$bakkey = Navigation::resolve_step ( $this );
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_GET );
		
		$uid = (isset ( $_POST ['uid'] )) ? $_POST ['uid'] : $_GET ['uid'];
		
		$list = array ();
		
		if ($uid) {
			
			$itemresp = new Entity ( 'vw_responses', $uid );
			
			$em = new EntityManager ( 'vw_responsesdetail' );
			
			$questions = $em->load ( 'responserecordid = :uid ', array(':uid' => $uid) );
			
			foreach ( $questions as $item ) {
				
				if (! $list [$item->questionid]) {
					$list [$item->questionid] = array ();
				}
				array_push ( $list [$item->questionid], $item );
			}
			
			$wfe = new WFEngine ();
			
			$listStates = $wfe->get_wf_record_next_states ( SESSION::get_activerole ()->role_code, $itemresp->statuscodeid, $uid );
			
			$this->screen ( $this->contextname . "/index", array (
					'list' => $list,
					'item' => $itemresp,
					'pvars' => $pvars,
					'navkey' => $navkey,
					'bakkey' => $bakkey,
					'states' => $listStates 
			) );
		} else {
			
			LogManagement::log ( "edit record error : invalid id", "update", "Records", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			
			header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
		}
	}
	
	/**
	 * saves status of record processing via workflow
	 */
	function save() {
		if ($_POST) {
			
			$uid = $_REQUEST ['uid'];
			$record = new DataRecord ( $uid );
			
			$wfe = new WFEngine ();
			$role = SESSION::get_activerole ()->role_code;
			$listStates = $wfe->get_wf_record_next_states ( $role, $record->statuscodeid, $record->id );
			
			$step = $wfe::search_step ( $listStates, $_POST ['recordstatus'] );
			
			if ($step != null) {
				
				try {
					Transaction::beginTransaction ();
					
					$record->statuscodeid = $_POST ['recordstatus'];
					$record->annotation = $_POST ['annotation'];
					$record->save ();
					
					$record->createHistory ();
					
					$wfe->run_postaction_step ( $step );
					
					Transaction::commit ();
					LogManagement::log ( "save Record " . $record->id, "update", "Records", __LOGTYPE_DATA );
				} catch ( Exception $exp ) {
					Transaction::rollback ();
					dump_errorlog ( $this->context, 'save', $exp->getMessage () );
					
					header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
				}
			} else { // error
				$rsp = getError ( "msg_error_save_cluster" );
				
				Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_GET, $rsp );
				
				LogManagement::log ( "save Record error : parameters error", "update", "Records", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			}
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl ( $this->contextname ) );
	}
}

?>