<?php
/**
 * NFPanalyse Context
 *
 * Context for Data Record analysis at NFP level
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataRecords
 */
class context_nfpanalyse extends context {
	public $contextname = "nfpanalyse";
	
	/**
	 * Constructor & Authorization
	 */
	function context_nfpanalyse() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows Dataset listing acording to filtering via POST
	 */
	function index() {
		Navigation::resolve_step ( $this );
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		if (! isset ( $_POST ['type'] )) {
			$_POST ['type'] = __STATISTICAL_TYPE_VICTIMS;
		}
		
		if (! isset ( $_POST ['recordstatus'] )) {
			$start_value = __RECORD_STATUS_COMPLETED;
		} else {
			$start_value = $_POST ['recordstatus'];
		}
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'gender', $_POST ['gender'], $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'birthdate', $_POST ['birthdate'], $da::TYPE_DATE ) );
		array_push ( $args, $da->helper_args ( 'agegroup', $_POST ['agegroup'], $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'statisticaltype', $_POST ['type'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'citizenship', $_POST ['citizenship'], $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'countrybirth', $_POST ['countrybirth'], $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'year', $_POST ['year'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'formofexploitation', $_POST ['formofexplotation'], $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'recordstatus', $start_value, $da::TYPE_TEXT ) );
		
		$sql = "select id as uid, statisticaltypeid as type , organisationname as organisation, statuscodeid as status, clusterid as cluster , publishcodeid as publication, embargodate, annotation from
					base.responserecordselect(:gender, :birthdate, :agegroup, :statisticaltype, \n
					:citizenship , :countrybirth, :year , :formofexploitation, :recordstatus)";
		
		$list = $da->func_get ( $sql, $args );
		
		$aset = array ();
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'pvars' => $pvars,
				'assistedSet' => $aset,
				'rules' => $listRules,
				'navkey' => $navkey 
		) );
	}
	
	function exportexcel() {
	
		ob_clean();
		//-------------- data processing
	
		//checkboxes selected:
	
		$ids = array();
	
		foreach($_POST as $key => $value) {
				
			if (substr( $key, 0, 2 ) === "ck") {
				if ($value == 'on') {
					$pieces = explode("_",$key);
					$id = $pieces[1];
				}
				array_push($ids,$id);
			}
		}
	
		$ids_str = implode(',',$ids);
	
		//end checkboxes selected
	
		$statisticaltypeid = $_POST['type'];
	
		$da = new DataAccess ();
	
		$args = array ();
	
		array_push ( $args, $da->helper_args ( 'ids', $ids_str, $da::TYPE_TEXT ) );
		array_push ( $args, $da->helper_args ( 'statisticaltypeid', $statisticaltypeid, $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'languageid', Session::get_language()->id, $da::TYPE_INTEGER ) );
	
		$sql = "select * from  base.export_nfpresponses (:ids,:statisticaltypeid,:languageid)";
	
		$list = $da->func_get ( $sql, $args );
	
		$aset = array ();
	
		$excel_lines = array();
		foreach ( $list as $item ) {
			$cols = array();
			$cols = explode("*#",$item->excel_line);
			array_push($excel_lines,$cols);
		}
	
		//------------------------------
	
		date_default_timezone_set('Europe/London');
	
	
		// Create new PHPExcel object
		$objPHPExcel = new PHPExcel();
	
		// Set document properties
		$objPHPExcel->getProperties()->setCreator("Mosy")
		->setLastModifiedBy("Mosy")
		->setTitle("Export Excel")
		->setSubject("Export Excel")
		->setDescription("Export Excel")
		->setKeywords("Export Excel");
	
		$objPHPExcel->setActiveSheetIndex(0);
	
	
		$line = 1;
		foreach($excel_lines as $excel_line) {
				
			$col = 'A';
			foreach($excel_line as $colvalue) {
					
				$objPHPExcel->getActiveSheet()->getColumnDimension($col)->setAutoSize(true);
				//$value = $colvalue;
				$value = html_entity_decode($colvalue);
				$value = str_replace("\\n", "\n", $value);
				$objPHPExcel->getActiveSheet()->setCellValue($col.$line,$value);
				$col++;
			}
			$line++;
		}
	
		//Title
		$objPHPExcel->getActiveSheet()->setTitle('Export from Mosy');
	
	
		// Redirect output to a clients web browser (Excel2007)
		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="export_mosy.xlsx"');
		header('Cache-Control: max-age=0');
		// If you're serving to IE 9, then the following may be needed
		header('Cache-Control: max-age=1');
	
		// If you're serving to IE over SSL, then the following may be needed
		header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
		header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		header ('Pragma: public'); // HTTP/1.0
	
		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
		$objWriter->save('php://output');
	
		exit;
	}
}