<?php
require_once "app/class-dataset.php";

/**
 * EFPcollect Context
 *
 * Context for DataSet Record publication at EFP level
 *
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataSets
 */
class context_efppublish extends context {
	public $contextname = "efppublish";
	
	/**
	 * Constructor & Authorization
	 */
	function context_efppublish() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows Dataset listing acording to filtering via POST
	 */
	function index() {
		Navigation::resolve_step ( $this );
		
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'fromdate', $_POST ['fromdate'], $da::TYPE_DATE ) );
		array_push ( $args, $da->helper_args ( 'todate', $_POST ['todate'], $da::TYPE_DATE ) );
		array_push ( $args, $da->helper_args ( 'statisticaltype', $_POST ['type'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'orgid', $_POST ['organisationid'], $da::TYPE_INTEGER ) );
		array_push ( $args, $da->helper_args ( 'status', __RECORD_STATUS_VALID . "," . __RECORD_STATUS_INVALID, $da::TYPE_TEXT ) );
		
		$sql = "select id , statisticaltypeid , organisationname , statuscodeid , setdate , fromperiod ,toperiod , annotation, publishcodeid
				from base.datasetfileselect(:fromdate,:todate, :statisticaltype, :orgid, :status)";
		
		$list = $da->func_get ( $sql, $args );
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'pvars' => $pvars,
				'navkey' => $navkey 
		) );
	}
	
	/**
	 * Marks datasets as aproved for publication
	 */
	function markpublishable() {
		//Navigation::resolve_step ( $this );
		
		//$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_POST );
		
		$listrecordsvalid = false;
		
		$arrrecordids = get_ck_list_ids ( $_POST );
		
		if (count ( $arrrecordids ) > 0) {
			
			$em = new EntityManager ( Dataset::LISTVIEW );
			$list = $em->load ( "id in (" . implode ( ",", $arrrecordids ) . ")" );
			
			foreach ( $list as $item ) {
				$listrecordsvalid = ($item->statuscodeid == __RECORD_STATUS_VALID && $item->publishcodeid == __PUBLISHED_STATUS_UNPUBLISHED);
				if (! $listrecordsvalid)
					break;
			}
		}
		
		if ($listrecordsvalid) {
			$listids = implode ( ",", $arrrecordids );
			
			$da = new DataAccess ();
			
			$args = array ();
			array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
			array_push ( $args, $da->helper_args ( 'rids', '{' . $listids . '}', $da::TYPE_TEXT ) );
			
			$sql = "select base.efp_publishable(:userid , :rids )";
			
			$res = $da->func_get ( $sql, $args );
			
			if (isset ( $res [0] ) && $res [0]->efp_publishable == null) {
				
				setNotification ( getSuccess ( "msg_markpublishable_sucess" ) );
				
				// Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
				
				LogManagement::log ( " EFP mark publishable records sucess", "update", "Dataset", __LOGTYPE_DATA );
			} else {
				
				setNotification ( getError ( "msg_markpublishable_error" ), Notification::TYPE_ERROR );
				Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, null );
				
				LogManagement::log ( " EFP mark publishable records error : " . $res [0]->efp_publishable, "update", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
			}
		} else {
			setNotification ( getError ( "msg_markpublishable_error" ), Notification::TYPE_ERROR );
			Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, null );
			LogManagement::log ( " EFP mark publishable invalid records selection", "update", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * * Generates EFP pre realease statistics
	 */
	function prereleasestats() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select statistic.calculate_indicators(:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->calculate_indicators == null) {
			
			setNotification(getSuccess( "msg_pre_relase_statistics" ));
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( "EFP pre realease statistics", "update", "Datasets", __LOGTYPE_DATA );
		} elseif ((isset ( $res [0] ) && $res [0]->calculate_indicators == 0)) {
			
			setNotification(getNotification( "msg_pre_relase_statistics_noaction" ),Notification::TYPE_WARNING);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " EFP pre realease statistics no new data to calculate : " . $res [0]->calculate_indicators, "update", "Dataset", __LOGTYPE_DATA );
		} else {
			
			setNotification(getError ( "msg_pre_relase_statistics_error" ),Notification::TYPE_ERROR);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " EFP pre realease statistics error : " . $res [0]->calculate_indicators, "update", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
	
	/**
	 * Generates EFP final realease statistics
	 */
	function releasestats() {
		$da = new DataAccess ();
		
		$args = array ();
		array_push ( $args, $da->helper_args ( 'userid', Session::get_user ()->id, $da::TYPE_INTEGER ) );
		
		$sql = "select statistic.finalstatistics(:userid)";
		
		$res = $da->func_get ( $sql, $args );
		
		if (isset ( $res [0] ) && $res [0]->finalstatistics == null) {
			
			setNotification(getSuccess( "msg_relase_statistics" ));
			
			//Navigation::set_step ( $_GET [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( "EFP final realease statistics", "update", "Datasets", __LOGTYPE_DATA );
		} elseif ((isset ( $res [0] ) && $res [0]->finalstatistics == 0)) {
			
			setNotification(getNotification( "msg_relase_statistics_noaction" ),Notification::TYPE_WARNING);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " EFP final realease statistics no new data to calculate : " . $res [0]->finalstatistics, "update", "Dataset", __LOGTYPE_DATA );
		} else {
			
			setNotification(getError ( "msg_relase_statistics_error" ),Notification::TYPE_ERROR);
			
			//Navigation::set_step ( $_POST [Navigation::NEXTKEY], Navigation::BACKPOST_TYPE_POST, $rsp );
			
			LogManagement::log ( " EFP final realease statistics error : " . $res [0]->finalstatistics, "update", "Dataset", __LOGTYPE_DATA, __LOGLEVEL_ERROR );
		}
		
		header ( 'Location:' . __SITEBASE . '/' . Navigation::get_backurl () );
	}
}

?>