<?php
/**
 * Common Model context
 * 
 * Shows Common Model Data for Victims and Traffickers
 * @author balexandre - Advantis
 * @version 1.0.1
 * @package Backend\DataStructures
 * 
 */
class context_commonmodel extends context {
	private $contextname = "commonmodel";
	private $baseentity = "questionlist";
	function context_vdpromos() {
		main::check_auth_session ();
	}
	
	/**
	 * Constructor & Authorization
	 */
	function index() {
		$this->victims ();
	}
	
	/**
	 * Default action shows Common question listing for victims
	 */
	function victims() {
		$em = new EntityManager ( $this->baseentity );
		
		$list = $em->load ( "statisticaltype_code='V'" );
		
		$this->screen ( $this->contextname . "/index", array (
				'page' => 'victims',
				"list" => $list,
				"contextname" => $this->contextname 
		) );
	}
	
	/**
	 * Default action shows Common question listing for traffickers
	 */
	function traffickers() {
		$em = new EntityManager ( $this->baseentity );
		
		$list = $em->load ( "statisticaltype_code='T'" );
		
		$this->screen ( $this->contextname . "/index", array (
				'page' => 'traffickers',
				"list" => $list,
				"contextname" => $this->contextname 
		) );
	} 
}