<?php
require_once "app/class-cluster.php";

/**
 * Clusters Context
 *
 * Context for clusters listing
 *
 * @author tmouzinho - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Clusters
 */
class context_clusters extends context {
	
	public $contextname = "clusters";
	
	/**
	 * Constructor & Authorization
	 */
	function context_clusters() {
		main::check_auth_session ();
	}
	
	/**
	 * Default action shows cluster listing
	 */
	function index() {
		$navkey = Navigation::set_step ( $this->contextname, Navigation::BACKPOST_TYPE_GET );
		
		$pvars = $this->data ['pvars'];
		
		$list = array ();
		
		$em = new EntityManager ( Cluster::LISTVIEW );
		$list = $em->load ();
		
		$this->screen ( $this->contextname . "/index", array (
				'list' => $list,
				'item' => $item1,
				'pvars' => $pvars,
				'navkey' => $navkey 
		) );
	}
}

?>