<?php
require_once 'app/class-lov-manager.php';

/**
 * Object Workflow
 * 
 * Support class for Workflow properties and transitions
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Workflows 
 */
class Workflow {
	
	// Workflows context types
	const __CTX_TYPE_RECORD_LLO = 1;
	const __CTX_TYPE_RECORD_NFP = 2;
	const __CTX_TYPE_RECORDSET = 5;
	const __CTX_TYPE_CLUSTER = 3;
	const __CTX_TYPE_CLUSTERMEMBER = 4;
	const __CTX_TYPE_DATASET_EFP = 6;
	public $steps; //
	public $type;
	
	/**
	 * Construtor
	 *
	 * @param int $type        	
	 */
	function Workflow($type) {
		$this->type = $type;
		$this->steps = array ();
	}
	
	/**
	 * gets DB configure steps for this workflow type
	 * according to role in session and starting step.
	 * Includes always starting step if exists
	 *
	 * @param string $fromRole        	
	 * @param string $fromStateCode        	
	 * @return array[WorkflowStep]
	 */
	function get_steps($fromRole, $fromStateCode) {
		
		// same
		$step = new WorkflowStep ();
		$role = Session::get_activerole ();
		$lovmanager = new LovManager ();
		
		switch ($this->type) {
			case self::__CTX_TYPE_CLUSTER :
				$statuslist = $lovmanager->getLov_ClusterStatus ();
				break;
			case self::__CTX_TYPE_CLUSTERMEMBER :
				$statuslist = $lovmanager->getLov_ClusterMemberStatus ();
				break;
			
			case self::__CTX_TYPE_RECORD_LLO :
				$statuslist = $lovmanager->getLov_RecordStatus ();
				break;
			
			case self::__CTX_TYPE_RECORD_NFP :
				$statuslist = $lovmanager->getLov_RecordStatus ();
				break;
			
			case self::__CTX_TYPE_RECORDSET :
				$statuslist = $lovmanager->getLov_RecordsetStatus ();
				break;
			case self::__CTX_TYPE_DATASET_EFP :
				$statuslist = $lovmanager->getLov_RecordStatus ();
				break;
		}
		
		$item = $lovmanager->getLov_item ( $statuslist, $fromStateCode );
		
		$step->set_step ( $item->id, $item->descriptioncode, $item->id, $item->descriptioncode, $role->role_code, $role->role_code, $role->roleid, $role->roleid, null, null, null, null, null );
		
		if ($this->steps [$fromRole . "#" . $fromStateCode]) {
			$stepsfilter = $this->steps [$fromRole . "#" . $fromStateCode];
		} else {
			$stepsfilter = array ();
		}
		
		array_unshift ( $stepsfilter, $step );
		
		return $stepsfilter;
	}
	
	/**
	 * Validates if wf is type Record LLO
	 * 
	 * @return boolean
	 */
	public function is_wf_record_llo() {
		return $this->type == self::__CTX_TYPE_RECORD_LLO;
	}
	
	/**
	 * Validates if wf is type Record NFP
	 * 
	 * @return boolean
	 */
	public function is_wf_record_nfp() {
		return $this->type == self::__CTX_TYPE_RECORD_NFP;
	}
	
	/**
	 * Validates if wf is type RecordSET
	 * 
	 * @return boolean
	 */
	public function is_wf_recordset() {
		return $this->type == self::__CTX_TYPE_RECORDSET;
	}
	
	/**
	 * Validates if wf is type CLUSTER
	 *
	 * @return boolean
	 */
	public function is_wf_cluster() {
		return $this->type == self::__CTX_TYPE_CLUSTER;
	}
	
	/**
	 * Validates if wf is type Cluster Member
	 * 
	 * @return boolean
	 */
	public function is_wf_clustermember() {
		return $this->type == self::__CTX_TYPE_CLUSTERMEMBER;
	}
	
	/**
	 * Validates if wf is type dataset
	 * 
	 * @return boolean
	 */
	public function is_wf_dataset() {
		return $this->type == self::__CTX_TYPE_DATASET_EFP;
	}
}

?>
