<?php
/**
 * Object WorkflowStep
 * 
 * Support class for workflow steps
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Workflows
 */
class WorkflowStep {
	public $from_statecode_id;
	public $to_statecode_id;
	public $from_statecode_description;
	public $to_statecode__description;
	public $from_role_code;
	public $to_role_code;
	public $from_role_id;
	public $to_role_id;
	public $alerttypeid;
	public $step_validation_rule;
	public $post_action;
	public $alert_description;
	public $alert_contextid;
	
	/**
	 * Prepares new WorkflowStep
	 *
	 * @param int $from_statecode_id        	
	 * @param string $from_statecode_desc        	
	 * @param int $to_statecode_id        	
	 * @param string $to_statecode_desc        	
	 * @param string $from_role_code        	
	 * @param string $to_role_code        	
	 * @param int $from_role_id        	
	 * @param int $to_role_id        	
	 * @param int $alerttypeid        	
	 * @param int $step_validation_rule        	
	 * @param int $post_action        	
	 * @param string $alert_description        	
	 * @param string $alert_contextid        	
	 */
	function set_step($from_statecode_id, $from_statecode_desc, $to_statecode_id, $to_statecode_desc, $from_role_code, $to_role_code, $from_role_id, $to_role_id, $alerttypeid, $step_validation_rule, $post_action, $alert_description, $alert_contextid) {
		$this->from_statecode_id = $from_statecode_id;
		$this->to_statecode_id = $to_statecode_id;
		$this->from_statecode_description = $from_statecode_desc;
		$this->to_statecode__description = $to_statecode_desc;
		$this->from_role_code = $from_role_code;
		$this->to_role_code = $to_role_code;
		$this->from_role_id = $from_role_id;
		$this->to_role_id = $to_role_id;
		$this->alerttypeid = $alerttypeid;
		$this->step_validation_rule = $step_validation_rule;
		$this->post_action = $post_action;
		$this->alert_description = $alert_description;
		$this->alert_context = $alert_contextid;
	}
}

?>
