<?php
/**
 * Entity User managment
 * 
 * Performs User operations
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Users
 */
class UserManager {
	
	// Role shortnames
	const __ROLE_LOCALCOLLECTOR = 'LC';
	const __ROLE_LOCALANALYST = 'LA';
	const __ROLE_LOCALPUBLISHER = 'LP';
	const __ROLE_NATIONALCOLLECTOR = 'NC';
	const __ROLE_NATIONALANALYST = 'NA';
	const __ROLE_NATIONALPUBLISHER = 'NP';
	const __ROLE_DATAAUDITOR = 'DA';
	const __ROLE_DATAMANAGER = 'DM';
	const __ROLE_SECURITYAUDITOR = 'SA';
	const __ROLE_SECURITYMANAGER = 'SM';
	const __ROLE_ORGANISATIONMEMBER = 'OM';
	
	/**
	 *
	 * @param unknown $user        	
	 * @param unknown $username        	
	 * @param unknown $password        	
	 * @return boolean
	 */
	function validate_user($user, $username, $password) {
		if ($user->username == $username && password_verify ( $password, $user->passwd ) && $user->active == 1 && ! $user->blocked) {
			
			return true;
		} else
			return false;
	}
	
	/**
	 *
	 * @param unknown $password        	
	 * @return string
	 */
	function generate_password($password) {
		return password_hash ( $password, PASSWORD_BCRYPT, array (
				'cost' => 12 
		) );
	}
	
	/**
	 *
	 * @return multitype:
	 */
	function get_user_roles() {
		if (Session::get_userroles ())
			
			return Session::get_userroles ();
		
		else {
			
			$em = new EntityManager ( "userrolelist" );
			
			$results = array ();
			
			if ($this->get_userid_in_session ())
				$results = $em->load ( 'userid=?', array (
						$this->get_userid_in_session () 
				) );
			
			return $results;
		}
	}
	
	/**
	 */
	function load_user_roles() {
		Session::set_userroles ( $this->get_user_roles () );
	}
	
	/**
	 */
	function get_userid_in_session() {
		return Session::get_user ()->id;
	}
	
	/**
	 *
	 * @param unknown $roleid        	
	 * @return boolean
	 */
	function role_security($roleid) {
		$userroles = $this->get_user_roles ();
		
		$userrole = $this->get_userrole ( $roleid );
		
		if ($this->get_userid_in_session () == $userrole->userid && $userrole->roleid == $roleid)
			return true;
		
		return false;
	}
	
	/**
	 *
	 * @param unknown $roleid        	
	 */
	function set_active_role($roleid) {
		if ($this->role_security ( $roleid )) {
			
			Session::set_activerole ( $this->get_userrole ( $roleid ) );
		}
	}
	
	/**
	 */
	function get_active_userrole() {
		if (Session::get_activerole ()) {
			
			return Session::get_activerole ();
		} else {
			/**
			 * role default
			 */
			
			$userroles = $this->get_user_roles ();
			Session::set_activerole ( $userroles [0] );
			return Session::get_activerole ();
		}
	}
	
	/**
	 *
	 * @param unknown $id        	
	 * @return unknown
	 */
	function get_userrole($id) {
		$userroles = $this->get_user_roles ();
		foreach ( $userroles as $userrole ) {
			if ($userrole->roleid == $id)
				return $userrole;
		}
	}
	
	/**
	 *
	 * @return unknown|Entity
	 */
	function get_user_org() {
		$org = Session::get_org ();
		
		if ($org != null && isset ( $org->id )) {
			
			return $org;
		} else {
			
			$org = new Entity ( "organisations", Session::get_user ()->organisationid );
			
			Session::set_org ( $org );
			
			return $org;
		}
	}
}

?>