<?php
/**
 * Session managment
 * 
 * @author ba - Advantis
 * @version 1.0.1
 * @package Base
 */
class Session {
	
	private static $name = __SESSIONBASE;
	
	/**
	 */
	public static function reset() {
		unset ( $_SESSION [self::$name] );
	}
	
	/**
	 */
	public static function check_active() {
		
		// echo $_SESSION[self::$name]['LAST_ACTIVITY']; echo " - " ; echo __SESSION_EXPIRES ;echo " - ";echo time(); exit();
		if (isset ( $_SESSION [self::$name] ['LAST_ACTIVITY'] ) && $_SESSION [self::$name] ['LAST_ACTIVITY'] + __SESSION_EXPIRES < time ()) {
			self::reset ();
		} else {
			self::set_active ();
		}
	}
	
	/**
	 */
	public static function set_active() {
		$_SESSION [self::$name] ['LAST_ACTIVITY'] = time ();
	}
	
	/**
	 *
	 * @param User $obj        	
	 */
	public static function set_user($obj) {
		$_SESSION [self::$name] ['user'] = $obj;
	}
	
	/**
	 */
	public static function get_user() {
		return $_SESSION [self::$name] ['user'];
	}
	
	/**
	 *
	 * @param unknown $obj        	
	 */
	public static function set_workflows($obj) {
		$_SESSION [self::$name] ['workflows'] = $obj;
	}
	
	/**
	 */
	public static function get_workflows() {
		return $_SESSION [self::$name] ['workflows'];
	}
	
	/**
	 *
	 * @param unknown $value        	
	 */
	public static function set_activerole($value) {
		$_SESSION [self::$name] ['active_role'] = $value;
	}
	
	/**
	 */
	public static function get_activerole() {
		return $_SESSION [self::$name] ['active_role'];
	}
	
	/**
	 *
	 * @param unknown $value        	
	 */
	public static function set_userroles($value) {
		$_SESSION [self::$name] ['userroles'] = $value;
	}
	
	/**
	 */
	public static function get_userroles() {
		return $_SESSION [self::$name] ['userroles'];
	}
	
	/**
	 *
	 * @param unknown $value        	
	 */
	public static function set_language($value) {
		$_SESSION [self::$name] ['settings'] ['language'] = $value;
	}
	
	/**
	 */
	public static function get_language() {
		return $_SESSION [self::$name] ['settings'] ['language'];
	}
	
	/**
	 *
	 * @param unknown $code        	
	 * @param unknown $value        	
	 */
	public static function set_language_descriptions($code, $value) {
		$_SESSION [self::$name] ['settings'] ['language_descriptions'] [$code] = $value;
	}
	
	/**
	 *
	 * @param unknown $code        	
	 */
	public static function get_language_descriptions($code) {
		return $_SESSION [self::$name] ['settings'] ['language_descriptions'] [$code];
	}
	
	/**
	 *
	 * @param unknown $code        	
	 * @param unknown $value        	
	 */
	public static function set_language_resources($code, $value) {
		$_SESSION [self::$name] ['settings'] ['language_resources'] [$code] = $value;
	}
	
	/**
	 *
	 * @param unknown $code        	
	 */
	public static function get_language_resources($code) {
		return $_SESSION [self::$name] ['settings'] ['language_resources'] [$code];
	}
	
	/**
	 *
	 * @param unknown $id        	
	 */
	public static function set_lime_callback_id($id) {
		$_SESSION [self::$name] ['lime_callback_id'] = $id;
	}
	
	/**
	 */
	public static function get_lime_callback_id() {
		return $_SESSION [self::$name] ['lime_callback_id'];
	}
	
	/**
	 *
	 * @param unknown $value        	
	 */
	public static function set_URI($value) {
		$_SESSION [self::$name] ['URI'] = $value;
	}
	
	/**
	 */
	public static function get_URI() {
		return $_SESSION [self::$name] ['URI'];
	}
	
	/**
	 *
	 * @param unknown $str        	
	 */
	public static function set_contextname($str) {
		$_SESSION [self::$name] ['contextname'] = $str;
	}
	
	/**
	 */
	public static function get_contextname() {
		return $_SESSION [self::$name] ['contextname'];
	}
	
	/**
	 */
	public static function unload_language() {
		unset ( $_SESSION [self::$name] ['settings'] );
	}
	
	/**
	 *
	 * @param unknown $obj        	
	 */
	public static function set_org($obj) {
		$_SESSION [self::$name] ['org'] = $obj;
	}
	
	/**
	 */
	public static function get_org() {
		return $_SESSION [self::$name] ['org'];
	}
	
	/**
	 * add serialized object to hash navigation with context string name as key
	 *
	 * @param object $obj
	 *        	// usually the serialized form of the $_POST or $_GET object
	 * @param string $key        	
	 */
	public static function add_navigationstep($obj, $key) {
		if (! isset ( $_SESSION [self::$name] ['navigationstep'] )) {
			$_SESSION [self::$name] ['navigationstep'] = array ();
		}
		
		$_SESSION [self::$name] ['navigationstep'] [$key] = $obj;
	}
	
	/**
	 * returns serialized object from hash navigation
	 *
	 * @param string $key
	 *        	// usually the context name string
	 */
	public static function check_navigationstep($key) {
		return $_SESSION [self::$name] ['navigationstep'] [$key];
	}
	
	/**
	 * returns serialized object from hash navigation and removes it from the navigstion hash
	 *
	 * @param string $key
	 *        	// usually the context name string
	 * @return object // usually the serialized form of the $_POST or $_GET object
	 */
	public static function get_navigationstep($key) {
		$arr = $_SESSION [self::$name] ['navigationstep'] [$key];
		
		unset ( $_SESSION [self::$name] ['navigationstep'] [$key] );
		
		return $arr;
	}
	
	/**
	 * Clears all navigation steps
	 */
	public static function clear_navigationsteps() {
		unset ( $_SESSION [self::$name] ['navigationstep'] );
	}
	
	/**
	 * add notification to hash notification by type - error,warning or success
	 *
	 * @param Notification $obj        	
	 */
	public static function add_notification($obj) {
		if (! isset ( $_SESSION [self::$name] ['notifications'] )) {
			$_SESSION [self::$name] ['notifications'] = array ();
		}
		
		array_push ( $_SESSION [self::$name] ['notifications'], serialize ( $obj ) );
	}
	
	/**
	 * Returns all notifications from notification hash and resets
	 *
	 * @return array
	 */
	public static function get_notifications() {
		$arr = null;
		
		if (isset ( $_SESSION [self::$name] ['notifications'] )) {
			
			$arr = array ();
			
			foreach ( $_SESSION [self::$name] ['notifications'] as $n ) {
				array_push ( $arr, unserialize ( $n ) );
			}
			
			unset ( $_SESSION [self::$name] ['notifications'] );
		}
		
		return $arr;
	}
}

?>