<?php
/** 
 * DataRecord Entity
 * 
 * NFP Data Record object supports data from eternal integration
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataRecords
 */
class DataRecord extends Entity {
	
	// DB Model
	const BASEENTITY = 'responserecords';
	const HISTORYENTITY = 'responserecordhistory';
	const LISTVIEW = 'vw_responses';
	
	public $id;
	public $statisticaltypeid;
	public $organisationid;
	public $limetoken;
	public $validfrom;
	public $embargodate;
	public $pseudoid;
	public $recordsetid;
	public $statuscodeid;
	public $publishcodeid;
	public $userid;
	public $annotation;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function DataRecord($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * prepares new Datarecord of MasterRecord type of a Recordset
	 *
	 * @param int $stattypeid        	
	 * @param int $userid        	
	 * @param int $recordsetid        	
	 * @param string $embargodate        	
	 */
	function setNewMaster($stattypeid, $userid, $recordsetid, $embargodate = null) {
		$this->statisticaltypeid = $stattypeid;
		$this->organisationid = __DATA_COLLECTOR_ORGANISATION; // organisation master by default
		$this->limetoken = null;
		$this->embargodate = $embargodate;
		$this->validfrom = date ( "Y-m-d" );
		$this->pseudoid = null;
		$this->statuscodeid = __RECORD_STATUS_UNDERREVIEW; // startup record status by default
		$this->publishcodeid = __PUBLISHED_STATUS_UNPUBLISHED; // startup published status by default
		$this->userid = $userid;
		$this->annotation = null;
		$this->recordsetid = $recordsetid;
	}
	
	/**
	 * Creates a history entry for the current state of the object
	 *
	 * @return boolean
	 */
	function createHistory() {
		if (! isset ( $this->id )) {
			return false;
		} else {
			$da = new DataAccess ();
			$cfgdb = new ConfigDB ();
			$schema = $cfgdb->connections ["DEFAULT"] ["DBSCHEMA"];

			$da->func_get ("INSERT INTO " . $schema . "." . self::HISTORYENTITY . "(responserecordid,statuscodeid,publishcodeid,annotation,userid,actiondate) select id, statuscodeid, publishcodeid, annotation, userid, now() from base." . self::BASEENTITY . " where id = :id", array(':id' => $this->id)   );
			return true;
		}
	}
}

?>
