<?php
/**
 * LLORecord Entity
 * 
 * Support for Record information support resident in external system
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataRecords 
 */
class LLORecord extends Entity {
	
	// DB Model
	const BASEENTITY = 'responsestatus';
	const HISTORYENTITY = 'responsestatushistory';
	public $id;
	public $statisticaltypeid;
	public $limetoken;
	public $statuscodeid;
	public $publishcodeid;
	public $userid;
	public $annotation;
	public $provisionagreementid;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function LLORecord($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Creates a history entry for the current state of the object
	 *
	 * @return boolean
	 */
	function createHistory() {
		if (! isset ( $this->id )) {
			return false;
		} else {
			$da = new DataAccess ();
			$cfgdb = new ConfigDB ();
			$schema = $cfgdb->connections ["DEFAULT"] ["DBSCHEMA"];

			$da->func_get ("INSERT INTO " . $schema . "." . self::HISTORYENTITY . "(responsestatusid,statuscodeid,publishcodeid,annotation,userid,actiondate) select id, statuscodeid, publishcodeid, annotation, userid, now() from base." . self::BASEENTITY . " where id = :id", array(':id' => $this->id)   );
			
			return true;
		}
	}
}

?>