<?php
/** 
 * Entities descriptions, resources Manager
 * 
 * Multi-language support for descriptions and resources operations
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Base
 */
class LanguageManager {
	
	/**
	 * Load all description for session language to session
	 */
	function load_descriptions() {
		$em = new EntityManager ( 'descriptions' );
		
		$result = $em->load ( 'languageid=?', array (
				Session::get_language ()->id 
		) );
		
		foreach ( $result as $value ) {
			
			Session::set_language_descriptions ( $value->code, $value->valuetext );
		}
	}
	
	/**
	 * Load all Resources from specific or Session language to session
	 *
	 * @param string $langid        	
	 */
	function load_resources($langid = null) {
		$em = new EntityManager ( 'resources' );
		
		if ($langid) {
			$result = $em->load ( 'languageid=?', array (
					$langid 
			) );
		} else {
			$result = $em->load ( 'languageid=?', array (
					Session::get_language ()->id 
			) );
		}
		
		foreach ( $result as $value ) {
			
			Session::set_language_resources ( $value->code, $value->valuetext );
		}
	}
	
	/**
	 * Resets session language data
	 */
	function unload_language() {
		Session::unload_language ();
	}
}

?>