<?php
/**
 * Manager class for file managment 
 * 
 * Support for file data manipulation
 * @author balexandre - Advantis Solutions
 * @version 1.0.1
 * @package Backend\Files
 */
class FileManager {
	
	/**
	 * Gets file stream by id an type
	 *
	 * @param int $id        	
	 * @param string $type        	
	 * @return string
	 */
	public static function retrievefile_NFP($id, $type) {
		$filename = $id;
		
		$basepath = __EXPORT_FILE_PATH;
		
		$NFP_CODE = __NFP_CODE;
		
		$path = $basepath . '/' . $NFP_CODE . '/' . $type;
		
		$file = fopen ( $path . '/' . $filename, "r" ) or die ( "Unable to open file!" );
		
		$contents = '';
		
		while ( ! feof ( $file ) ) {
			$contents .= fgets ( $file );
		}
		
		return $contents;
	}
	
	/**
	 * Retrieves file stream by NFP, id and type
	 *
	 * @param string $NFP_CODE        	
	 * @param int $id        	
	 * @param string $type        	
	 * @return string
	 */
	public static function retrievefile_EFP($NFP_CODE, $id, $type) {
		$filename = $id;
		
		$basepath = __EFP_IMPORT_FILE_PATH;
		
		$path = $basepath . '/' . $NFP_CODE . '/' . $type;
		
		$file = fopen ( $path . '/' . $filename, "r" ) or die ( "Unable to open file!" );
		
		$contents = '';
		
		while ( ! feof ( $file ) ) {
			$contents .= fgets ( $file );
		}
		
		return $contents;
	}
	
	/**
	 * Validates if files exists by NFP, id and type
	 *
	 * @param unknown $NFP_CODE        	
	 * @param unknown $id        	
	 * @param unknown $type        	
	 * @return boolean
	 */
	public static function verifyfile($NFP_CODE, $id, $type) {
		$filename = $id;
		
		$basepath = __EFP_IMPORT_FILE_PATH;
		
		$path = $basepath . '/' . $NFP_CODE . '/' . $type;
		
		$ok = file_exists ( $path . '/' . $filename );
		
		return $ok;
	}
}

?>