<?php
/**
 * Data Provisions Entity
 * 
 * Support class for DPA
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\DataStructures 
 */
class DataProvisions extends Entity {
	
	// DB Model
	const BASEENTITY = 'provisionagreements';
	const LISTVIEW = 'provisionagreementdsdlist';
	public $id;
	public $description;
	public $datastructuredefinitionid;
	public $fromorganisationid;
	public $toorganisationid;
	public $validfrom;
	public $validto;
	public $frequencycodeid; // Item code identifier for reliability CodeList.
	public $publicationdeadline;
	public $reliabilitycodeid;
	public $versionregistryid;
	public $active;
	public $embargotime; // Publishing embargo time defined in weeks
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function DataProvisions($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares New DPA
	 *
	 * @param string $description        	
	 * @param int $fromorganisationid        	
	 * @param date $validfrom        	
	 * @param date $validto        	
	 * @param int $datastructuredefinitionid        	
	 * @param int $frequencycodeid        	
	 * @param date $publicationdeadline        	
	 * @param int $reliabilitycodeid        	
	 * @param int $versionregistryid        	
	 * @param int $embargotime        	
	 */
	function setNew($description, $fromorganisationid, $validfrom, $validto, $datastructuredefinitionid, $frequencycodeid, $publicationdeadline, $reliabilitycodeid, $versionregistryid, $embargotime) {
		$this->description = $description;
		$this->datastructuredefinitionid = $datastructuredefinitionid;
		$this->fromorganisationid = $fromorganisationid;
		$this->toorganisationid = __DATA_COLLECTOR_ORGANISATION; // By definition its always to master organisation
		$this->validfrom = $validfrom;
		$this->validto = $validto;
		$this->frequencycodeid = $frequencycodeid;
		$this->publicationdeadline = $publicationdeadline;
		$this->reliabilitycodeid = $reliabilitycodeid;
		$this->versionregistryid = $versionregistryid;
		$this->active = 0; // start status by default
		$this->embargotime = $embargotime;
	}
}

?>
