<?php
require_once "app/class-cluster-member.php";
require_once "app/class-recordset.php";

/**
 * Cluster Entity
 * 
 * Support class for cluster of Data Records
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Clusters
 */
class Cluster extends Entity {
	
	// DB Model
	const BASEENTITY = 'clusters';
	const HISTORYENTITY = 'clusterhistory';
	const LISTVIEW = 'clusterlist';
	public $id;
	public $creationtypecodeid;
	public $prioritycodeid;
	public $statuscodeid;
	public $userid;
	public $annotation;
	public $clusterruleid;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function Cluster($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares new Cluster
	 *
	 * @param int $creationtypecodeid        	
	 * @param int $prioritycodeid        	
	 * @param int $userid        	
	 * @param string $annotation        	
	 * @param int $clusterruleid        	
	 */
	function setNew($creationtypecodeid, $prioritycodeid, $userid, $annotation, $clusterruleid = null) {
		$this->creationtypecodeid = $creationtypecodeid;
		$this->prioritycodeid = $prioritycodeid;
		$this->userid = $userid;
		$this->statuscodeid = __CLUSTER_STATUS_UNCONFIRMED;
		$this->annotation = $annotation;
		$this->clusterruleid = $clusterruleid;
	}
	
	/**
	 * Creates a history entry for the current state of the object
	 *
	 * @return boolean
	 */
	function createHistory() {
		if (! isset ( $this->id )) {
			return false;
		} else {
			$da = new DataAccess ();
			$cfgdb = new ConfigDB ();
			$schema = $cfgdb->connections ["DEFAULT"] ["DBSCHEMA"];

			$da->func_get ("INSERT INTO " . $schema . "." . self::HISTORYENTITY . "(clusterid,statuscodeid,annotation,userid,actiondate) select id, statuscodeid, annotation, userid, now() from base." . self::BASEENTITY . " where id = :id", array(':id' => $this->id) );
			
			return true;
		}
	}
	
	/**
	 * Creates members from listids
	 * 
	 * @param array $listids        	
	 * @return boolean
	 */
	function createMembers($listids) {
		if (! isset ( $this->id )) {
			return false;
		} else {
			foreach ( $listids as $record ) {
				$clustermember = new ClusterMember ();
				$clustermember->setNew ( $this->id, $record );
				$em = new EntityManager ( $clustermember::BASEENTITY );
				$clustermember = $em->create ( $clustermember );
				
				$clustermember->createHistory ();
			}
			
			return true;
		}
	}
	
	/**
	 * Get records associated with the culster as cluster members
	 *
	 * @return NULL|array
	 */
	function get_members() {
		if (! isset ( $this->id ))
			return null;
		
		$em = new EntityManager ( ClusterMember::LISTVIEW );
		
		$results = $em->load ( "clustermembers_clusterid = :clusterid order by responserecords_ID asc ", array(':clusterid' => $this->id) );
		
		return $results;
	}
	
	/**
	 * Get recordsets associated with the culster
	 *
	 * @return NULL|array
	 */
	function get_recordsets() {
		if (! isset ( $this->id ))
			return null;
		
		$em = new EntityManager ( Recordset::LISTVIEW );
		
		$results = $em->load ( "clusterid = :clusterid", array( ':clusterid' => $this->id ));
		
		return $results;
	}
}

?>

