<?php
/** 
 * Entity Cluster Member
 * 
 * Cluster member Object manages record association with clusters
 * @author tm - Advantis
 * @version 1.0.1
 * @package Backend\Clusters 
 */
class ClusterMember extends Entity {
	
	// DB Model
	const BASEENTITY = 'clustermembers';
	const HISTORYENTITY = 'clustermemberhistory';
	const LISTVIEW = 'clustermemberslist';
	
	public $id;
	public $clusterid;
	public $responserecordid;
	public $statuscodeid;
	
	/**
	 * Construtor
	 * If $id is passed gets entity from DB model baseentity
	 *
	 * @param int $id
	 *        	(optional)
	 */
	function ClusterMember($id = null) {
		parent::Entity ( $this::BASEENTITY, $id );
	}
	
	/**
	 * Prepares new ClusterMember for DB
	 *
	 * @param int $clusterid        	
	 * @param int $responserecordid        	
	 */
	function setNew($clusterid, $responserecordid) {
		$this->clusterid = $clusterid;
		$this->responserecordid = $responserecordid;
		$this->statuscodeid = __CLUSTER_MEMBER_STATUS_POTENCIALDUPLICATE; // start default state
	}
	
	/**
	 * Creates a history entry for the current state of the object
	 *
	 * @return boolean
	 */
	function createHistory() {
		if (! isset ( $this->id )) {
			return false;
		} else {
			$da = new DataAccess ();
			$cfgdb = new ConfigDB ();
			$schema = $cfgdb->connections ["DEFAULT"] ["DBSCHEMA"];

			$da->func_get ("INSERT INTO " . $schema . "." . self::HISTORYENTITY . "(clustermemberid,clusterid,statuscodeid,userid,actiondate) select id, clusterid, statuscodeid, " . Session::get_user ()->id . ", now() from base." . self::BASEENTITY . " where id = :id", array(':id' => $this->id) );
			
			return true;
		}
	}
}

?>

