<?php

/**
 * Authorization manager
 * 
 * Performs Authorization operations
 * @author ba - Advantis Solutions
 * @version 1.0.1
 * @package Base
 */
class Authorization {
	
	/**
	 * Validates Authorization for context in session
	 *
	 * @return string [__ACCESS_FORBIDDEN|__ACCESS_READ|__ACCESS_WRITE]
	 */
	public static function context_access_mode() {
		$config = unserialize ( __AUTHORIZATIONS );
		$confighosts = unserialize ( __AUTHORIZATIONS_HOSTS );

		if ($confighosts [Session::get_contextname ()] && $confighosts [Session::get_contextname ()] != $_SERVER ['REMOTE_ADDR']) {
			
			return __ACCESS_FORBIDDEN;
		} else {
			
			if (! Session::get_activerole ()) {
				
				if (! $config [Session::get_contextname ()]) {
					
					return __ACCESS_FORBIDDEN;
				} 

				else {
					return $config [Session::get_contextname ()] ['ANONYMOUS'];
				}
			} else {
				
				if (self::write_access ( Session::get_contextname () )) {
					return __ACCESS_WRITE;
				} else if (self::read_access ( Session::get_contextname () )) {
					return __ACCESS_READ;
				} else {
					return __ACCESS_FORBIDDEN;
				}
			}
		}
	}
	
	/**
	 * Views Authorization for context
	 *
	 * @param string $context        	
	 * @return boolean
	 */
	public static function view_access($context) {
		if (self::read_access ( $context ) || self::write_access ( $context ))
			return true;
		
		return false;
	}
	
	/**
	 * Evaluates context read access from __AUTHORIZATIONS array
	 *
	 * @param string $context        	
	 * @return boolean
	 */
	public static function read_access($context) {
		$config = unserialize ( __AUTHORIZATIONS );
		
		if ($config [$context] [Session::get_activerole ()->role_code] == __ACCESS_READ)
			return true;
		
		return false;
	}
	
	/**
	 * Evaluates context write access from __AUTHORIZATIONS array
	 *
	 * @param string $context        	
	 * @return boolean
	 */
	public static function write_access($context) {
		$config = unserialize ( __AUTHORIZATIONS );
		
		if ($config [$context] [Session::get_activerole ()->role_code] == __ACCESS_WRITE)
			return true;
		
		return false;
	}
}

?>