<?php

/*
* LimeSurvey
* Copyright (C) 2007-2011 The LimeSurvey Project Team / Carsten Schmitz
* All rights reserved.
* License: GNU/GPL License v2 or later, see LICENSE.php
* LimeSurvey is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*
*/

class remotecontrol extends Survey_Common_Action
{
    /**
    * @var Zend_XmlRpc_Server
    */
    protected $xmlrpc;

    /**
    * This is the XML-RPC server routine
    *
    * @access public
    * @return void
    */
    public function run()
    {
        Yii::import('application.helpers.remotecontrol.*');
        $oHandler=new remotecontrol_handle($this->controller);
        $RPCType=Yii::app()->getConfig("RPCInterface");
        if (Yii::app()->getRequest()->isPostRequest) {
            if ($RPCType=='xml')
            {
                $cur_path = get_include_path();
                set_include_path($cur_path . PATH_SEPARATOR . APPPATH . 'helpers');
                // Yii::import was causing problems for some odd reason
                require_once('Zend/XmlRpc/Server.php');
                require_once('Zend/XmlRpc/Server/Exception.php');
                require_once('Zend/XmlRpc/Value/Exception.php');
                $this->xmlrpc = new Zend_XmlRpc_Server();
                $this->xmlrpc->sendArgumentsToAllMethods(false);
                Yii::import('application.libraries.LSZend_XmlRpc_Response_Http');
                $this->xmlrpc->setResponseClass('LSZend_XmlRpc_Response_Http');
                $this->xmlrpc->setClass($oHandler);
                /* @var LSZend_XmlRpc_Response_Http */
                $result = $this->xmlrpc->handle();
                $result->printXml();
            }
            elseif($RPCType=='json')
            {
                Yii::app()->loadLibrary('LSjsonRPCServer');
                if (!isset($_SERVER['CONTENT_TYPE']))
                {
                    $serverContentType = explode(';', $_SERVER['HTTP_CONTENT_TYPE']);
                    $_SERVER['CONTENT_TYPE'] = reset($serverContentType);
                }
                LSjsonRPCServer::handle($oHandler);
            }
			foreach (App()->log->routes as $route)
			{
				$route->enabled = $route->enabled && !($route instanceOf CWebLogRoute);
			}

            exit;
        } else {
            // Disabled output of API methods for now
            if (Yii::app()->getConfig("rpc_publish_api") == true && in_array($RPCType, array('xml', 'json'))) {
                $reflector = new ReflectionObject($oHandler);
                foreach ($reflector->getMethods(ReflectionMethod::IS_PUBLIC) as $method) {
                    /* @var $method ReflectionMethod */
                    if (substr($method->getName(),0,1) !== '_') {
                        $list[$method->getName()] = array(
                            'description' => str_replace(array("\r", "\r\n", "\n"), "<br/>", $method->getDocComment()),
                            'parameters'  => $method->getParameters()
                        );
                    }
                }
                ksort($list);
                $aData['method'] = $RPCType;
                $aData['list'] = $list;
                $aData['display']['menu_bars'] = false; // Hide normal menu bar
                $this->_renderWrappedTemplate('remotecontrol', array('index_view'), $aData);
            }
        }
    }

    /**
    * Simple procedure to test most RPC functions
    *
    */
    public function test()
    {
        die(); // Remove if you want to test this function
        $RPCType=Yii::app()->getConfig("RPCInterface");
        $serverUrl = App()->createAbsoluteUrl('/admin/remotecontrol');
        $sFileToImport=dirname(Yii::app()->basePath).DIRECTORY_SEPARATOR.'docs'.DIRECTORY_SEPARATOR.'demosurveys'.DIRECTORY_SEPARATOR.'limesurvey2_sample_survey_english.lss';

        if ($RPCType == 'xml') {
            $cur_path = get_include_path();
            set_include_path($cur_path . PATH_SEPARATOR . APPPATH . 'helpers');
            require_once('Zend/XmlRpc/Client.php');
            
            $client = new Zend_XmlRpc_Client($serverUrl);
        } elseif ($RPCType == 'json') {
            Yii::app()->loadLibrary('jsonRPCClient');
            $client = new jsonRPCClient($serverUrl);
        }
        else die('RPC interface not activated in global settings');
        

        $sSessionKey= $client->call('get_session_key', array('admin','password'));
        if (is_array($sSessionKey)) {echo $sSessionKey['status']; die();}
        else
        {
            echo 'Retrieved session key'.'<br>';
        }
        
        $sLSSData=base64_encode(file_get_contents($sFileToImport));
        $iSurveyID=$client->call('import_survey', array($sSessionKey, $sLSSData, 'lss','Test import by JSON_RPC',1000));
        echo 'Created new survey SID:'.$iSurveyID.'<br>';

        $aResult=$client->call('activate_survey', array($sSessionKey, $iSurveyID));
        if ($aResult['status']=='OK')
        {
            echo 'Survey '.$iSurveyID.' successfully activated.<br>';
        }
        $aResult=$client->call('activate_tokens', array($sSessionKey, $iSurveyID,array(1,2)));
        if ($aResult['status']=='OK')
        {
            echo 'Tokens for Survey ID '.$iSurveyID.' successfully activated.<br>';
        }
        $aResult=$client->call('set_survey_properties', array($sSessionKey, $iSurveyID,array('faxto'=>'0800-LIMESURVEY')));
        if (!array_key_exists('status', $aResult))
        {
            echo 'Modified survey settings for survey '.$iSurveyID.'<br>';
        }
        $aResult=$client->call('add_language', array($sSessionKey, $iSurveyID,'ar'));
        if ($aResult['status']=='OK')
        {
            echo 'Added Arabian as additional language'.'<br>';
        }
        $aResult=$client->call('set_language_properties', array($sSessionKey, $iSurveyID,array('surveyls_welcometext'=>'An Arabian welcome text!'),'ar'));
        if ($aResult['status']=='OK')
        {
            echo 'Modified survey locale setting welcometext for Arabian in survey ID '.$iSurveyID.'<br>';
        }

        $aResult=$client->call('delete_language', array($sSessionKey, $iSurveyID,'ar'));
        if ($aResult['status']=='OK')
        {
            echo 'Removed Arabian as additional language'.'<br>';
        }

        //Very simple example to export responses as Excel file
        //$aResult=$client->call('export_responses', array($sSessionKey,$iSurveyID,'xls'));
        //$aResult=$client->call('export_responses', array($sSessionKey,$iSurveyID,'pdf'));
        //$aResult=$client->call('export_responses', array($sSessionKey,$iSurveyID,'doc'));
        $aResult=$client->call('export_responses', array($sSessionKey,$iSurveyID,'csv'));
        //file_put_contents('test.xls',base64_decode(chunk_split($aResult)));

        $aResult=$client->call('delete_survey', array($sSessionKey, $iSurveyID));
        echo 'Deleted survey SID:'.$iSurveyID.'-'.$aResult['status'].'<br>';

        // Release the session key - close the session
        $Result= $client->call('release_session_key', array($sSessionKey));
        echo 'Closed the session'.'<br>';

    }


}
